# QuoteSearch
POST [http://quotesearchapi.dellsvc/quotes/search](http://quotesearchapi.dellsvc/quotes/search "http://quotesearchapi.dellsvc/quotes/search") & - [https://quotesearchapi.dellsvc/quotesearch/quotes/search](https://quotesearchapi.dellsvc/quotesearch/quotes/search)
### Searching Gii Quotes in v1.1

##### Reference for Gii quote number mapping
- The term “TargetReference” is the name of references field that gets added on to Quote(V3) upon imported/translated from Gii Offer. Quote Search API has enabled a search ability on that field property and hence the same name has been retained on QuoteSearch API request contract.
- Offer number and Offer version are Gii system generated Offer number and version number for Gii Quotes(also referred as Offers in Gii system).
- Org Id has a cross-lookup with country which is maintained on Gii system’s end:

|COUNTRY_NAME|ORG_ID|BU_CODE|BU_ID|
|---|---|---|---|
|AP CPF|381|C2|4081|
|Australia|376|AU|1401|
|Austria|334|AT|3838|
|Belgium|322|BE|2828|
|Belgium (B9)|991|B9|9928|
|China|374|CN|8270|
|China RHQ|399|C3|270|
|CPF|336|CP|5458|
|Cyberjaya|402|M2|4047|
|Czech Republic|363|CZ|3434|
|Denmark|330|DK|1224|
|Distributor|380|DI|4075|
|EDB|324|ED|5455|
|Finland|331|FI|1222|
|France|328|FR|909|
|France (F9)|998|F9|9909|
|Germany|323|DE|808|
|Germany (D9)|993|D9|9980|
|Greece|342|GR|5000|
|HK China|379|XM|8242|
|Hong Kong|377|HK|4042|
|Hungary|368|HU|552|
|India (Dell India Pvt Ltd)|384|I3|1717|
|India (ICC INR)|383|I2|7460|
|India (ICC USD)|382|I1|7465|
|Indonesia|390|ID|439|
|Ireland|301|IE|5102|
|Ireland (I9)|996|I9|9951|
|Israel|369|IL|572|
|Italy|329|IT|6161|
|Japan|389|JP|3535|
|Korea|386|KR|4545|
|Luxembourg|366|LU|531|
|Malaysia|375|MY|4046|
|Netherlands|325|NL|2121|
|Netherlands (N9)|997|N9|9921|
|New Zealand|378|NZ|4065|
|Norway|326|NO|2323|
|Poland|362|PL|3131|
|Portugal|364|PT|2929|
|Russian Federation|370|RU|546|
|Saudi Arabia|372|SA|584|
|Singapore|385|SG|1313|
|Slovakia|365|SK|592|
|Slovakia (S8)|984|S8|9959|
|South Africa|337|ZA|6969|
|Spain|327|ES|1919|
|Sweden|332|SE|1212|
|Switzerland|335|CH|2727|
|Switzerland (C7)|985|C7|9927|
|Taiwan|387|TW|1841|
|Thailand|388|TH|4444|
|Turkey|371|TR|551|
|Ukraine|373|UA|547|
|United Arab Emirates|367|AE|5959|
|United Kingdom|302|GB|202|
|United kingdom (G9)|989|G9|9920|

##### v1.1 request payload 
```json
{
  "queryFilters": {
    "expressions": [
      {
        "field": "QuoteStatus",
        "operation": "Equals",
        "values": [
          "QUOTED"
        ]
      },
      {
        "field": "QuoteCreatedDate",
        "operation": "GreaterThan",
        "values": [
          "2023-09-20T20:24:13.5563653+00:00"
        ]
      }
    ],
    "complexExpressions": {
      "reference": {
       // "targetReference": "28685385.0.376",
        "targetSystem": "GDAS_GII"
      }
    }
  },
  "queryOptions": {
    "queryResults": {
      "pagination": {
        "pageNumber": 1,
        "pageSize": 10
      },
      "orderBy": [
        {
          "field": "QuoteCreatedDate",
          "sortBy": "Descending"
        }
      ]
    }
  }
}
```
# Quote
### G4
##### Example1
3001017596761.1 - Solution products - March 2023
##### GET Quote output 
```json
{
  "$schema": "http://dell.com/dcp/schemas/quote/3.0.0#",
  "id": "Pc2kVWftD0a_LkAXwRaQIw~001",
  "number": 3001017596761,
  "version": 1,
  "status": "Quoted",
  "createdOn": "2023-02-14T18:09:36.5058029+00:00",
  "lastModifiedOn": "2023-02-14T18:10:18.3527475+00:00",
  "quotedDate": "2023-02-14T18:10:18.3527447+00:00",
  "expiresOn": "2023-03-16T23:59:59-05:00",
  "retentionDays": 540,
  "contact": {
    "firstName": "AMBILI",
    "lastName": "SASIDHARAN",
    "companyName": "DECIBEL RESEARCH INC",
    "customerNumber": "550000257458",
    "emailAddress": "S_Gayathri@dell.com",
    "warrantyEmail": "",
    "phoneContacts": [
      {
        "countryCode": "1",
        "areaCode": "512",
        "number": "3344445",
        "phoneType": "Home"
      },
      {
        "countryCode": "1",
        "areaCode": "512",
        "number": "3344445",
        "phoneType": "Work"
      }
    ],
    "camId": "550000257458",
    "camLocationId": "200000013492811",
    "address": {
      "city": "BORGER",
      "country": "US",
      "countryCode": 0,
      "id": "228767509213617911",
      "line1": "1412 CLAYTON ST",
      "postalCode": "79007-2506",
      "region": "TX"
    },
    "optInFlags": false,
    "additionalEmails": []
  },
  "items": [
    {
      "extendedPrice": 0,
      "id": "3_Y7vQf_N0yPMoCurq8OBg~001",
      "upgrade": {},
      "properties": {
        "isMCC": "true",
        "itemTrackingNumber": "1",
        "extensionData": "{\"GoalId\":null,\"Type\":null,\"OpportunityLineId\":null}",
        "dell:Commerce:OpenBasket:Item:ExtendedProperties:Override_cfi_flag": "false",
        "offerUniqueId": "a8b538d9-60ba-4f64-b059-079a047ace5b"
      },
      "quantity": 1,
      "timeToLive": {
        "sourceSystem": "DCQO",
        "expirationDate": "2023-02-14T18:09:58.1856155+00:00",
        "isExpired": true
      },
      "title": "MICROSOFT 365 E3",
      "unitPrice": 0,
      "unitQuantity": 1,
      "isParentAsset": false,
      "cfiComments": [],
      "clearPriceEnabled": false,
      "catalogId": 8,
      "configuredSelectionsUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/aVCeRg0q_Uu_htc2hUr2xw~001/selections",
      "itemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/aVCeRg0q_Uu_htc2hUr2xw~001",
      "openBasketCompleteItemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/aVCeRg0q_Uu_htc2hUr2xw~001/openBasketItem",
      "openBasketItemId": "e72b6932-04e2-497d-8d79-de5a756bc990",
      "openBasketItemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/aVCeRg0q_Uu_htc2hUr2xw~001/openBasketItem",
      "openBasketLiteUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/aVCeRg0q_Uu_htc2hUr2xw~001/openBasketLite",
      "orderCode": "630-BBBK",
      "pricingSummary": {
        "contractDiscountPercentage": 0,
        "contractPrice": 41.99,
        "dol": 0,
        "dolPercentage": 0,
        "ecoFee": 0,
        "itemId": "e72b6932-04e2-497d-8d79-de5a756bc990",
        "itemMarginPercentage": 17.29,
        "manualDiscountPercentage": 0,
        "manualDiscount": 0,
        "promotionsValue": 0,
        "promotionsPercentage": 0,
        "retailPrice": 45.45,
        "sellingPrice": 41.99,
        "salesTax": 0,
        "serviceContract": 0,
        "shippingAmount": 0,
        "shippingPriceDiscount": 0,
        "shippingManualDiscount": 0,
        "optionPriceSummary": [],
        "skuPriceSummary": [],
        "associatedItemPriceSummary": [],
        "stateEnvFee": 0,
        "taxAmount": 3.46,
        "totalListPrice": 41.99,
        "totalListPriceWithNonTiedItems": 0,
        "totalMargin": 7.26,
        "totalMarginWithNonTiedItems": 0,
        "totalMarginPercentWithNonTiedItems": 0,
        "totalAmount": 45.45,
        "totalCost": 34.73,
        "totalDiscountValue": 0,
        "totalDiscountPercent": 0,
        "unadjustedShippingAmount": 0,
        "unadjustedShippingAmountWithoutNonTiedItems": 0,
        "unitCost": 34.73,
        "unitDiscountValue": 0,
        "unitItemManualDiscount": 0,
        "unitDiscountPercentage": 0,
        "unitMargin": 7.26,
        "unitMarginPercentage": 17.29,
        "unitPrice": 41.99,
        "unitSellingPrice": 41.99,
        "contractDiscount": 0,
        "taxableAmount": 41.99,
        "nonTaxableAmount": 0,
        "effectiveTaxRate": 0,
        "taxInfo": [
          {
            "taxType": "SalesTax",
            "taxRate": 0.0825
          }
        ]
      },
      "product": {
        "baseSkuClass": "17000",
        "baseSkuClassDescription": "MICROSOFT 365 E3",
        "baseSkuNumber": "630-BBBK",
        "buildToStock": false,
        "catalogId": 8,
        "categories": [
          {
            "name": "All",
            "id": "0"
          }
        ],
        "category": "All",
        "chassisId": 0,
        "description": "MICROSOFT 365 E3",
        "extendedProperties": {
          "isRenewal": "True",
          "renewalDescription": "MICROSOFT 365 E3",
          "renewalPrice": "0.01",
          "listPrice": "0.01",
          "unspsC_Code": null,
          "variableItemGlobalIdentifier": "0",
          "isVariable": "False",
          "gbwitem_flag": "False",
          "isVariablePriced": "False",
          "retailPrice": "0.01",
          "deltaSalesPrice": "0",
          "deltaStandardPrice": "0",
          "deltaOfferPrice": "0",
          "deltaRetailPrice": "0",
          "offerPrice": "0.01",
          "bestCost": "0",
          "fpcCostCurrency": "USD",
          "variableAspectDuration": "",
          "variableAspectMaximum": "",
          "variableAspectMinimum": "",
          "variableAspectUnitOfMeasure": null,
          "sspCategoryID": null,
          "dataSource": "SSI_CDS",
          "isGOP": "False",
          "grouP_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/5f9efb0c-5318-43f5-b0f9-5501157dab78?region=amer",
          "ratE_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/5f9efb0c-5318-43f5-b0f9-5501157dab78?region=amer"
        },
        "id": "a8b538d9-60ba-4f64-b059-079a047ace5b",
        "inventoryLevel": "Normal",
        "inventoryQuantity": 0,
        "isDellwareOnly": false,
        "isLicensingProduct": false,
        "isSeItem": false,
        "isTiedSku": false,
        "itemBuildTime": 0,
        "manufacturerId": "0",
        "manufacturerName": "Dell",
        "orderCode": "630-BBBK",
        "productLineId": 0,
        "quantity": 1,
        "serviceTags": [],
        "sku": "630-BBBK",
        "skus": [
          {
            "allowMultiQuantity": false,
            "customFields": {
              "actiV_REQD": "0",
              "bilL_PROD": "11111",
              "bilL_TYPE": "Initial",
              "cadence": "MAF",
              "fB_DIGITAL": "Yes",
              "fB_DISCNT": "Yes",
              "fB_IS_SUB": "Yes",
              "fB_OFFGRP": "M365NCE",
              "fB_PRICE_R": "PROD",
              "fB_PRORATE": "Yes",
              "fB_PROV_BY": "DELP",
              "fB_PROWAIT": "No",
              "fB_QUOTSYS": "PROD",
              "fbprD_NAME": "NCE-Base",
              "finaccttre": "Defer",
              "fincogstre": "Defer",
              "finduratin": "12",
              "finitemcat": "FINSOFTWRE",
              "finleasprd": "Soft",
              "finlicprog": "None",
              "finmultacc": "Yes",
              "finrevaloc": "N",
              "finrevcls": "SnP FlexBilling SaaS",
              "finrpt": "Software",
              "finsoftype": "Software Suite",
              "finstrtdat": "1",
              "renewalSKU": "630-BBBK",
              "rplcmntprt": "False",
              "subsertype": "/service/msnce/o365",
              "xaaS_OFRTP": "XAAS_Subscription",
              "ratE_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/5f9efb0c-5318-43f5-b0f9-5501157dab78?region=amer",
              "vendorTenentID": "D72233C2-A69D-48E7-A865-5C21D1C455C0",
              "autoRenewalSelection": "OptIn",
              "itemclassification": "Simple offer",
              "offeR_ID": "AAAAA088",
              "offeR_DESCRIPTION": "Office 365 E3, Enterprise Mobility + Security E3, and Windows 10/11 Enterprise E3. This per-user licensed suite of products offers users best-in-class productivity across devices while providing IT security and control",
              "offeR_NAME": "Microsoft 365 E3",
              "offerType": "SaaS",
              "offerSubType": "EandOProductivity",
              "offerSelections": "[{\"key\":\"OFFBillCad\",\"value\":\"M\"},{\"key\":\"SUPPORT_LEVEL\",\"value\":\"BASIC\"},{\"key\":\"OFFNumbof\",\"value\":\"1\"},{\"key\":\"Term\",\"value\":\"1\"},{\"key\":\"OFFAutoRenewalFlag\",\"value\":\"OptIn\"}]",
              "ratE_PLAN_ID": "92329080",
              "offvendorsourceprovid": "Null",
              "offerVersionID": "30.0.0",
              "offOfferGro": "MS365",
              "offSalesOfferType": "Null",
              "vendorOfferID": "CFQ7TTC0LFLX:0001",
              "offVendorID": "MSFTCorp",
              "offvendorofferid": "CFQ7TTC0LFLX:0001",
              "offsubslif": "SubcriptionOrg,UpgradeStdCoTerm,AutoRenewal,ExpansionStdCoTerm,AutoRenewWithSchChanges,Cancel,UPDATE_STANDARD_CO_TERM",
              "offqtyvallvl": "OEMVal",
              "attsubstype": "Fixed",
              "offer_bu_segments": "11_MAIN",
              "issellable": "ATTYes",
              "uniqueId": "a8b538d9-60ba-4f64-b059-079a047ace5b",
              "vendorId": "MSFTCorp",
              "vendorTenentDomain": "e2etesting30101.onmicrosoft.com",
              "solutionTransactionType": "NEW_SUBSCRIPTION",
              "subscriptionTransactionObject": "{\"action\": \"NEW_SUBSCRIPTION\"}"
            },
            "description": "MICROSOFT 365 E3",
            "discountClass": "A",
            "durationDays": 0,
            "durationMonths": 0,
            "isCfi": false,
            "isFactoryInstalled": false,
            "isRequired": false,
            "isServiceSku": false,
            "isTied": false,
            "isVariable": false,
            "isVariablePriced": false,
            "lobId": "99",
            "optionQuantity": 0,
            "placedPrice": 0.01,
            "quantity": 1,
            "skuClass": "17000",
            "skuNumber": "630-BBBK",
            "status": "B",
            "subscriptionInformation": {
              "id": "630-BBBK",
              "name": "MICROSOFT 365 E3",
              "renewalAmount": 0.01,
              "skuId": "630-BBBK",
              "productType": "B",
              "cadence": "MAF",
              "subscriptionServiceType": "/service/msnce/o365"
            },
            "weight": 0,
            "parentItemTypeCode": "D",
            "itemTypeCode": "B",
            "fulfillmentLocation": "00",
            "rollupFlag": false,
            "isFlexi": false
          }
        ],
        "status": "B",
        "taxes": [],
        "type": "SubscriptionOffer",
        "weight": 0,
        "allowChangeQuantity": false,
        "shipsWith": false,
        "isVariablePriced": false,
        "validationResult": {
          "isValid": false
        },
        "isPCaaSItem": false,
        "parentItemId": "00000000-0000-0000-0000-000000000000",
        "unitQuantity": 1
      },
      "sku": "630-BBBK",
      "type": "SubscriptionOffer",
      "validations": [],
      "extendedProperties": [
        {
          "key": "ManufacturingLeadDays",
          "value": "0"
        }
      ],
      "customerSpecificFields": [],
      "requiresRefresh": false
    },
    {
      "extendedPrice": 0,
      "id": "VHa41PIrO0qLk7OdNTbZjA~001",
      "upgrade": {},
      "properties": {
        "isMCC": "true",
        "itemTrackingNumber": "1",
        "extensionData": "{\"GoalId\":null,\"Type\":null,\"OpportunityLineId\":null}",
        "dell:Commerce:OpenBasket:Item:ExtendedProperties:Override_cfi_flag": "false"
      },
      "quantity": 1,
      "timeToLive": {
        "sourceSystem": "DCQO",
        "expirationDate": "2023-02-14T18:10:29.997613+00:00",
        "isExpired": true
      },
      "title": "Microsoft 365 F5 Security",
      "unitPrice": 0,
      "unitQuantity": 1,
      "isParentAsset": false,
      "cfiComments": [],
      "clearPriceEnabled": false,
      "catalogId": 8,
      "configuredSelectionsUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/7AKv20uRh06ozjfElsvjTA~001/selections",
      "itemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/7AKv20uRh06ozjfElsvjTA~001",
      "openBasketCompleteItemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/7AKv20uRh06ozjfElsvjTA~001/openBasketItem",
      "openBasketItemId": "2f050d87-46e2-4b90-a696-ecd967c7e597",
      "openBasketItemUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/7AKv20uRh06ozjfElsvjTA~001/openBasketItem",
      "openBasketLiteUrl": "http://item-snapshot-svc.g4.dell.com/v1/items/7AKv20uRh06ozjfElsvjTA~001/openBasketLite",
      "orderCode": "630-BBBN",
      "pricingSummary": {
        "contractDiscountPercentage": 0,
        "contractPrice": 7.78,
        "dol": 0,
        "dolPercentage": 0,
        "ecoFee": 0,
        "itemId": "2f050d87-46e2-4b90-a696-ecd967c7e597",
        "itemMarginPercentage": 17.35,
        "manualDiscountPercentage": 0,
        "manualDiscount": 0,
        "promotionsValue": 0,
        "promotionsPercentage": 0,
        "retailPrice": 8.42,
        "sellingPrice": 7.78,
        "salesTax": 0,
        "serviceContract": 0,
        "shippingAmount": 0,
        "shippingPriceDiscount": 0,
        "shippingManualDiscount": 0,
        "optionPriceSummary": [],
        "skuPriceSummary": [],
        "associatedItemPriceSummary": [],
        "stateEnvFee": 0,
        "taxAmount": 0.64,
        "totalListPrice": 7.78,
        "totalListPriceWithNonTiedItems": 0,
        "totalMargin": 1.35,
        "totalMarginWithNonTiedItems": 0,
        "totalMarginPercentWithNonTiedItems": 0,
        "totalAmount": 8.42,
        "totalCost": 6.43,
        "totalDiscountValue": 0,
        "totalDiscountPercent": 0,
        "unadjustedShippingAmount": 0,
        "unadjustedShippingAmountWithoutNonTiedItems": 0,
        "unitCost": 6.43,
        "unitDiscountValue": 0,
        "unitItemManualDiscount": 0,
        "unitDiscountPercentage": 0,
        "unitMargin": 1.35,
        "unitMarginPercentage": 17.35,
        "unitPrice": 7.78,
        "unitSellingPrice": 7.78,
        "contractDiscount": 0,
        "taxableAmount": 7.78,
        "nonTaxableAmount": 0,
        "effectiveTaxRate": 0,
        "taxInfo": [
          {
            "taxType": "SalesTax",
            "taxRate": 0.0825
          }
        ]
      },
      "product": {
        "baseSkuClass": "17000",
        "baseSkuClassDescription": "Microsoft 365 F5 Security",
        "baseSkuNumber": "630-BBBN",
        "buildToStock": false,
        "catalogId": 8,
        "categories": [
          {
            "name": "All",
            "id": "0"
          }
        ],
        "category": "All",
        "chassisId": 0,
        "description": "Microsoft 365 F5 Security",
        "extendedProperties": {
          "isRenewal": "True",
          "renewalDescription": "Microsoft 365 F5 Security",
          "renewalPrice": "0.01",
          "listPrice": "0.01",
          "unspsC_Code": null,
          "variableItemGlobalIdentifier": "0",
          "isVariable": "False",
          "gbwitem_flag": "False",
          "isVariablePriced": "False",
          "retailPrice": "0.01",
          "deltaSalesPrice": "0",
          "deltaStandardPrice": "0",
          "deltaOfferPrice": "0",
          "deltaRetailPrice": "0",
          "offerPrice": "0.01",
          "bestCost": "0",
          "fpcCostCurrency": "USD",
          "variableAspectDuration": "",
          "variableAspectMaximum": "",
          "variableAspectMinimum": "",
          "variableAspectUnitOfMeasure": null,
          "sspCategoryID": null,
          "dataSource": "SSI_CDS",
          "isGOP": "False",
          "grouP_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/ff4baca8-3fc9-4d02-b039-4cd7195849e1?region=amer",
          "ratE_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/ff4baca8-3fc9-4d02-b039-4cd7195849e1?region=amer"
        },
        "id": "2f050d87-46e2-4b90-a696-ecd967c7e597",
        "inventoryLevel": "Normal",
        "inventoryQuantity": 0,
        "isDellwareOnly": false,
        "isLicensingProduct": false,
        "isSeItem": false,
        "isTiedSku": false,
        "itemBuildTime": 0,
        "manufacturerId": "0",
        "manufacturerName": "Dell",
        "orderCode": "630-BBBN",
        "productLineId": 0,
        "quantity": 1,
        "serviceTags": [],
        "sku": "630-BBBN",
        "skus": [
          {
            "allowMultiQuantity": false,
            "customFields": {
              "actiV_REQD": "0",
              "bilL_PROD": "11111",
              "bilL_TYPE": "Initial",
              "cadence": "MAF",
              "fB_DIGITAL": "Yes",
              "fB_DISCNT": "Yes",
              "fB_IS_SUB": "Yes",
              "fB_OFFGRP": "M365NCE",
              "fB_PRICE_R": "PROD",
              "fB_PRORATE": "Yes",
              "fB_PROV_BY": "DELP",
              "fB_PROWAIT": "No",
              "fB_QUOTSYS": "PROD",
              "fbprD_NAME": "NCE-Base",
              "finaccttre": "Defer",
              "fincogstre": "Defer",
              "finduratin": "12",
              "finitemcat": "FINSOFTWRE",
              "finleasprd": "Soft",
              "finlicprog": "None",
              "finmultacc": "Yes",
              "finrevaloc": "N",
              "finrevcls": "SnP FlexBilling SaaS",
              "finrpt": "Software",
              "finsoftype": "Software Suite",
              "finstrtdat": "1",
              "renewalSKU": "630-BBBN",
              "rplcmntprt": "False",
              "subsertype": "/service/msnce/o365",
              "xaaS_OFRTP": "XAAS_Subscription",
              "ratE_RESOURCE_URL": "https://rate-integrator-g4.pricing-v4-np.pcf.dell.com/v1/rate-cards/ff4baca8-3fc9-4d02-b039-4cd7195849e1?region=amer",
              "vendorTenentID": "D72233C2-A69D-48E7-A865-5C21D1C455C0",
              "autoRenewalSelection": "OptIn",
              "itemclassification": "Simple offer",
              "offeR_ID": "AAAAA098",
              "offeR_DESCRIPTION": "A complete set of threat protection solutions, leveraging cloud signal to detect and protect against threats to your organization, along with automated incident responses. A Microsoft 365 F1/F3 subscription is a pre-requisite for this plan.",
              "offeR_NAME": "Microsoft 365 F5 Security Add-on",
              "offerType": "SaaS",
              "offerSubType": "SecurityandCompliance",
              "offerSelections": "[{\"key\":\"Term\",\"value\":\"12\"},{\"key\":\"OFFBillCad\",\"value\":\"M\"},{\"key\":\"OFFNumbof\",\"value\":\"1\"},{\"key\":\"SUPPORT_LEVEL\",\"value\":\"BASIC\"},{\"key\":\"OFFAutoRenewalFlag\",\"value\":\"OptIn\"}]",
              "ratE_PLAN_ID": "102093518",
              "offvendorsourceprovid": "Null",
              "offerVersionID": "8.0.0",
              "offOfferGro": "MS365",
              "offSalesOfferType": "SWSVCSub",
              "vendorOfferID": "CFQ7TTC0MBMD:0006",
              "offVendorID": "MSFTCorp",
              "offer_bu_segments": "11_MAIN",
              "offsubslif": "SubcriptionOrg,UpgradeStdCoTerm,ExpansionStdCoTerm,AutoRenewal,Cancel,AutoRenewWithSchChanges,UPDATE_STANDARD_CO_TERM",
              "offqtyvallvl": "CumulativeDell",
              "issellable": "ATTYes",
              "offsuppnee": "ATTYes",
              "offofferseg": "SegEnt",
              "offvendorofferid": "CFQ7TTC0MBMD:0006",
              "attsubstype": "Fixed",
              "uniqueId": "2f050d87-46e2-4b90-a696-ecd967c7e597",
              "vendorId": "MSFTCorp",
              "vendorTenentDomain": "e2etesting30101.onmicrosoft.com",
              "solutionTransactionType": "NEW_SUBSCRIPTION",
              "subscriptionTransactionObject": "{\"action\": \"NEW_SUBSCRIPTION\"}"
            },
            "description": "Microsoft 365 F5 Security",
            "discountClass": "Z",
            "durationDays": 0,
            "durationMonths": 0,
            "isCfi": false,
            "isFactoryInstalled": true,
            "isRequired": false,
            "isServiceSku": false,
            "isTied": false,
            "isVariable": false,
            "isVariablePriced": false,
            "lobId": "99",
            "optionQuantity": 0,
            "placedPrice": 0.01,
            "quantity": 1,
            "skuClass": "17000",
            "skuNumber": "630-BBBN",
            "status": "B",
            "subscriptionInformation": {
              "id": "630-BBBN",
              "name": "Microsoft 365 F5 Security",
              "renewalAmount": 0.01,
              "skuId": "630-BBBN",
              "productType": "B",
              "cadence": "MAF",
              "subscriptionServiceType": "/service/msnce/o365"
            },
            "weight": 0,
            "parentItemTypeCode": "D",
            "itemTypeCode": "B",
            "fulfillmentLocation": "00",
            "rollupFlag": false,
            "isFlexi": false
          }
        ],
        "status": "B",
        "taxes": [],
        "type": "SubscriptionOffer",
        "weight": 0,
        "allowChangeQuantity": false,
        "shipsWith": false,
        "isVariablePriced": false,
        "validationResult": {
          "isValid": false
        },
        "isPCaaSItem": false,
        "parentItemId": "00000000-0000-0000-0000-000000000000",
        "unitQuantity": 1
      },
      "sku": "630-BBBN",
      "type": "SubscriptionOffer",
      "validations": [],
      "extendedProperties": [
        {
          "key": "ManufacturingLeadDays",
          "value": "0"
        }
      ],
      "customerSpecificFields": [],
      "requiresRefresh": false
    }
  ],
  "shipments": [
    {
      "id": "5t1Hvxx_rU2PjT9mPFiSLQ",
      "shipmentName": "Standard Delivery",
      "shippingMethod": "LD",
      "shippingOptions": [
        "LD"
      ],
      "shippingContact": {
        "firstName": "AMBILI",
        "lastName": "SASIDHARAN",
        "companyName": "DECIBEL RESEARCH INC",
        "customerNumber": "550000257458",
        "emailAddress": "S_Gayathri@dell.com",
        "warrantyEmail": "",
        "phoneContacts": [
          {
            "countryCode": "1",
            "areaCode": "512",
            "number": "3344445",
            "phoneType": "Home"
          }
        ],
        "camId": "550000257458",
        "camLocationId": "200000013492811",
        "address": {
          "city": "BORGER",
          "country": "US",
          "countryCode": 0,
          "id": "228767509213617911",
          "line1": "1412 CLAYTON ST",
          "postalCode": "79007-2506",
          "region": "TX"
        },
        "optInFlags": false,
        "additionalEmails": []
      },
      "contactReferences": [],
      "items": [
        {
          "quoteItemId": "3_Y7vQf_N0yPMoCurq8OBg~001",
          "estimatedShippingDateRange": {
            "max": "2023-02-14T00:00:00Z"
          },
          "estimatedDeliveryDateRange": {
            "max": "2023-02-15T00:00:00Z"
          },
          "estimatedServiceActivationDateRange": {}
        },
        {
          "quoteItemId": "VHa41PIrO0qLk7OdNTbZjA~001",
          "estimatedShippingDateRange": {
            "max": "2023-02-14T00:00:00Z"
          },
          "estimatedDeliveryDateRange": {
            "max": "2023-02-14T00:00:00Z"
          },
          "estimatedServiceActivationDateRange": {}
        }
      ],
      "properties": {},
      "priceSummary": {
        "shipmentId": "5t1Hvxx_rU2PjT9mPFiSLQ",
        "shippingPrice": 0,
        "totalShipping": 0,
        "shippingDiscount": 0,
        "subTotal": 49.77,
        "totalTax": 4.1,
        "ecoFees": 0,
        "totalAmount": 53.87,
        "shippingTax": 0,
        "adjustedShipping": 0,
        "shippingManualDiscount": 0
      },
      "itemGroupId": "4d3e0592-5025-450b-9501-184cb65ac820",
      "isUpgrade": false
    }
  ],
  "properties": {
    "dsa-validity-period": "{\"MaxExpirationDate\":\"2023-03-16T23:59:59-05:00\",\"QuoteExpirationDate\":\"2023-03-16T23:59:59-05:00\",\"ExpirationDates\":[{\"Source\":\"UserPreference\",\"Description\":\"User Preferences\",\"ExpirationDate\":\"2023-03-16T13:09:41.3350137\"},{\"Source\":\"BusinessUnit\",\"Description\":\"Business Unit\",\"ExpirationDate\":\"2023-03-16T13:09:41.3350137\"}],\"SourceForMaxExpiration\":\"Business Unit is determining the max expiration date.\"}",
    "defaultShipmentId": "5t1Hvxx_rU2PjT9mPFiSLQ",
    "aposFlexbillingEnabled": "false",
    "customerdefault-PaymentTerms": "Credit/Deb.Card",
    "dsa-FunderPaymentTerms": "Credit/Deb.Card",
    "thresholdPolicy": "DamWithSmartPrice",
    "isCommercial": "True",
    "dsA-SoldToCustomer": "{\"CustomerNumber\":\"550000257458\",\"CompanyName\":\"DECIBEL RESEARCH INC\",\"FirstName\":\"AMBILI\",\"MiddleName\":null,\"LastName\":\"SASIDHARAN\",\"Department\":null,\"EmailAddress\":\"S_Gayathri@dell.com\",\"WarrantyEmail\":\"\",\"DigitalFulfillmentEmail\":null,\"PhoneContacts\":[{\"CountryCode\":\"1\",\"AreaCode\":\"512\",\"Number\":\"3344445\",\"Extension\":null,\"PhoneType\":\"Home\"}],\"Fax\":null,\"Address\":{\"Id\":\"228767509213617911\",\"Line1\":\"1412 CLAYTON ST\",\"Line2\":null,\"Line3\":null,\"Line4\":null,\"City\":\"BORGER\",\"Region\":\"TX\",\"PostalCode\":\"79007-2506\",\"CountryCode\":0,\"Country\":\"US\",\"DomsSequenceNumber\":null,\"Suburb\":null},\"CamId\":\"550000257458\",\"CamLocationId\":\"200000013492811\",\"Title\":null,\"Properties\":null,\"Ucid\":null,\"PrimaryTaxId\":null,\"TaxIdPrimary\":null,\"TaxIdSecondary\":null,\"InvoiceType\":null,\"CarrierType\":null,\"CarrierID\":null,\"BankName\":null,\"TaxRegNo\":null,\"AccountNumber\":null}",
    "channelCustomerWithPAMAttribute": "false",
    "dsA-DefaultShipToCustomer": "{\"CustomerNumber\":\"550000257458\",\"CompanyName\":\"DECIBEL RESEARCH INC\",\"FirstName\":\"AMBILI\",\"MiddleName\":null,\"LastName\":\"SASIDHARAN\",\"Department\":null,\"EmailAddress\":\"S_Gayathri@dell.com\",\"WarrantyEmail\":\"\",\"DigitalFulfillmentEmail\":null,\"PhoneContacts\":[{\"CountryCode\":\"1\",\"AreaCode\":\"512\",\"Number\":\"3344445\",\"Extension\":null,\"PhoneType\":\"Home\"}],\"Fax\":null,\"Address\":{\"Id\":\"228767509213617911\",\"Line1\":\"1412 CLAYTON ST\",\"Line2\":null,\"Line3\":null,\"Line4\":null,\"City\":\"BORGER\",\"Region\":\"TX\",\"PostalCode\":\"79007-2506\",\"CountryCode\":0,\"Country\":\"US\",\"DomsSequenceNumber\":null,\"Suburb\":null},\"CamId\":\"550000257458\",\"CamLocationId\":\"200000013492811\",\"Title\":null,\"Properties\":null,\"Ucid\":null,\"PrimaryTaxId\":null,\"TaxIdPrimary\":null,\"TaxIdSecondary\":null,\"InvoiceType\":null,\"CarrierType\":null,\"CarrierID\":null,\"BankName\":null,\"TaxRegNo\":null,\"AccountNumber\":null}",
    "extensionData": "{\"IsDirty\":true,\"OpportunityId\":null,\"CreatedBy\":null,\"LastModifiedBy\":null,\"IsSmb\":false,\"PONumber\":null,\"SolutionId\":null,\"SolutionRegion\":null,\"SolutionVersion\":null,\"SolutionGroupId\":null,\"State\":null,\"POMId\":\"\",\"LinkId\":null,\"SolutionRequestOrigin\":null,\"OrderType\":null,\"POReceivedDate\":null,\"ExpiresOn\":\"2023-03-16T23:59:59-05:00\"}",
    "tradeComplianceSnapshotUrl": "http://snapshot-svc.g4.dell.com/snapshots/SLK9tY0rxU27UyudjKyK1Q~001",
    "fulfillmentUnitsSnapshotIdKey": "http://snapshot-svc.g4.dell.com/snapshots/2zqzsq-w-0Kgt1nKPmtxAQ~001",
    "cfiAdminOverride": "false",
    "isBulkCreatedOrder": "false",
    "readY_FOR_ONLINE_ORDERING": "true",
    "creatorSalesRepBadgeId": "868247",
    "dsa-ParentQuoteNumber": "3001017582572.1",
    "creatorSalesRepId": "12345",
    "modifiedByApplicationName": "DSP",
    "originalSourceApplicationName": "DSP",
    "canChangeSellingEntity": "true"
  },
  "customCheckOutFields": [],
  "customerSpecificFields": [],
  "extendedProperties": {
    "rcStoreId": "RC1387181"
  },
  "customSkuPricing": false,
  "priceStoreUrl": "https://prcsvc.g4.dell.com/DCP.PricingService.Sirius/V4/txnprice/Pc2kVWftD0a_LkAXwRaQIw~001",
  "priceReportingViewUrl": "https://prcsvc.g4.dell.com/DCP.PricingService.Sirius/V4/txnprice/Pc2kVWftD0a_LkAXwRaQIw~001?view=reporting",
  "priceShippingViewUrl": "https://prcsvc.g4.dell.com/DCP.PricingService.Sirius/V4/txnprice/Pc2kVWftD0a_LkAXwRaQIw~001?view=shippingdetailed",
  "priceSummaryUrl": "https://prcsvc.g4.dell.com/DCP.PricingService.Sirius/V4/txnprice/Pc2kVWftD0a_LkAXwRaQIw~001?view=summary",
  "priceDetailViewUrl": "https://prcsvc.g4.dell.com/DCP.PricingService.Sirius/V4/txnprice/Pc2kVWftD0a_LkAXwRaQIw~001?view=detailed",
  "references": [
    {
      "referenceType": "CopiedFrom",
      "referencedOn": "2023-02-14T18:09:36.6648968+00:00",
      "referenceCreatedBy": "DSP",
      "targetSystem": "QuoteService",
      "target": "http://quote-svc.g4.dell.com/v3/quotes/Rab3Jpe6Ykeuexo4qdVKcg~001"
    }
  ],
  "validations": [],
  "isUpgrade": false,
  "resellerException": "",
  "tradeCompliance": {
    "ref": "http://snapshot-svc.g4.dell.com/snapshots/SLK9tY0rxU27UyudjKyK1Q~001",
    "etag": "A4okGg"
  },
  "itemRelationships": "{\"SubscriptionOffers\":[\"aaaaa088\",\"aaaaa098\"]}",
  "createdBy": "Mohammad_Sadiq@Dell.com",
  "businessContext": {
    "sourceApplicationName": "DSP",
    "originalSourceApplicationName": "DSP",
    "companyNumber": "08",
    "country": "US",
    "currency": "USD",
    "customerSet": "usic1f",
    "language": "EN",
    "region": "US",
    "segment": "IC",
    "businessUnitId": "11",
    "pricingRegistrationIdsForTypes": {
      "withCustomerSummary": "7103b314-7620-4fc3-a9d8-f4fd93a24fd6",
      "withCustomerDetailed": "b4e1f3e1-2d19-46df-91e0-97d37948aaf4",
      "withoutCustomerSummary": "f0e78698-01d0-4a40-b7be-691a34419af7",
      "withoutCustomerDetailed": "5fece3bf-555e-4692-a920-c9cfbc84ef1d"
    },
    "destinationSystem": "OMEGA",
    "sellingEntity": "D",
    "customerAccountId": 0,
    "classCode": "C",
    "cdcEnabled": false,
    "isGlobalPortal": false,
    "useReseller": false,
    "band": 0,
    "isGop": false
  },
  "customer": {
    "id": "Bt-mQT3WhkKgk-k-5eq4kA~001",
    "name": "DECIBEL RESEARCH INC",
    "accountId": "0",
    "customerNumber": "550000257458",
    "company": {
      "name": "DECIBEL RESEARCH INC",
      "number": "08"
    },
    "omsCustomerId": "550000257458"
  },
  "pricingSummary": {
    "listPrice": 49.77,
    "sellingPrice": 49.77,
    "costPrice": 41.16,
    "discountPercentage": 0,
    "discountValue": 0,
    "compRevenue": 0,
    "totalMarginValue": 8.61,
    "marginPercentage": 17.3,
    "subTotal": 49.77,
    "shippingAmountBeforeDiscount": 0,
    "shippingAmount": 0,
    "shippingDiscountAmount": 0,
    "shippingManualDiscount": 0,
    "shippingTax": 0,
    "adjustedShipping": 0,
    "totalTax": 4.1,
    "taxAndShippingTax": 4.1,
    "ecoFee": 0,
    "finalPrice": 53.87,
    "damMarginVariance": 0,
    "damDiscountVariance": 0,
    "totalDamDiscountVariancePercentage": 0,
    "totalDamMarginVariancePercentage": 0,
    "taxableAmount": 49.77,
    "nonTaxableAmount": 0,
    "effectiveTaxRate": 0,
    "taxInfo": [
      {
        "taxType": "SalesTax",
        "taxRate": 0.0825
      }
    ]
  },
  "salesReps": [
    {
      "id": "ThSAzVRsXkOJdd-xQ05S9Q~001",
      "salesPersonNumber": 12345,
      "firstname": "Manjunath",
      "lastname": "Cp",
      "email": "Manjunath.Channapatn@Dell.com",
      "salesRepType": "Primary",
      "phone": {
        "countryCode": "1",
        "areaCode": "800",
        "number": "456-3355",
        "extension": "80000",
        "phoneType": "Work"
      },
      "hasSmartPriceRights": false
    },
    {
      "id": "PMEbqvjXRkiBJI2VDfG_Jw~001",
      "salesPersonNumber": 12345,
      "employeeId": "868247",
      "firstname": "Maleravalappil",
      "lastname": "Mohammad Sadiq",
      "email": "Mohammad_Sadiq@Dell.com",
      "salesRepType": "Processor",
      "phone": {
        "countryCode": "1",
        "areaCode": "800",
        "number": "456-3355",
        "extension": "7285673",
        "phoneType": "Work"
      },
      "hasSmartPriceRights": false
    }
  ],
  "paymentMethods": [
    {
      "id": "86c46602-1d0d-40fa-995c-72bf06bc64f3",
      "amount": 0,
      "isRecurring": false,
      "payeeAmount": 0,
      "description": "OP",
      "type": "OP",
      "creditRating": 0,
      "isPrepaid": false
    }
  ],
  "pomId": "",
  "priceAdjustments": [],
  "bypassSplittingRules": false,
  "contacts": [
    {
      "id": "877dPcS2gE6mlD5XmS6MtA~001",
      "resourceReference": {
        "eTag": "-1881792090",
        "schema": "http://dell.com/dcp/schemas/contact/1.0#",
        "sourceSystem": "ContactService",
        "location": "https://contact-svc.g4.dell.com/v1/contacts/ztA0ZiwCeUGzpevGVVVbkQ~001"
      },
      "type": "SoldTo"
    }
  ],
  "resellerMarkup": "",
  "isCpf": false
}
```


### G2
### Prod
```json
{
  "$schema": "string",
  "id": "string",
  "number": 0,
  "version": 0,
  "name": "string",
  "status": "Unknown",
  "createdOn": "2024-07-23T18:08:59.095Z",
  "lastModifiedOn": "2024-07-23T18:08:59.095Z",
  "quotedDate": "2024-07-23T18:08:59.095Z",
  "expiresOn": "2024-07-23T18:08:59.095Z",
  "retentionDays": 0,
  "currencyCode": "string",
  "orderPath": "string",
  "ratedOrder": {
    "programId": "string",
    "priority": "string"
  },
  "contact": {
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "companyName": "string",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "warrantyEmail": "string",
    "digitalFulfillmentEmail": "string",
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "extension": "string",
        "phoneType": "Work"
      }
    ],
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "extension": "string",
      "phoneType": "Work"
    },
    "camId": "string",
    "camLocationId": "string",
    "address": {
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "domsSequenceNumber": "string",
      "id": "string",
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "region": "string",
      "regionName": "string",
      "suburb": "string"
    },
    "optInFlags": true,
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "taxCategory": "string",
    "ucid": "string",
    "organizationInfo": {
      "branchName": "string",
      "department": "string",
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "string",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "shipToTaxCategory": "string",
    "invoiceType": "string",
    "taxRegNo": "string",
    "bankName": "string",
    "accountNumber": "string",
    "accountType": "string",
    "carrierType": "string",
    "carrierID": "string",
    "cpfGroupId": "string",
    "accountName": "string",
    "invoiceDeliveryMethod": "string",
    "language": "string",
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "compliance": {
      "taxRegime": "string",
      "eInvoiceFormat": "string",
      "taxRegimeDesc": "string",
      "eInvoiceFormatDesc": "string"
    }
  },
  "items": [
    {
      "transactCommerceContext": {
        "sourceApplicationName": "string"
      },
      "connectedProvisioning": {
        "rel": "string",
        "ref": "string",
        "etag": "string",
        "schema": "string"
      },
      "configItemId": {
        "parentConfigItemIdHashCode": 0,
        "collection": "None",
        "isTied": true,
        "moduleId": 0,
        "optionId": "string",
        "productId": "string"
      },
      "extendedPrice": 0,
      "id": "string",
      "parentId": "string",
      "productId": "string",
      "productImageUrl": "string",
      "productName": "string",
      "productUrl": "string",
      "upgrade": {
        "optoutReasonCode": "string"
      },
      "stockReservationId": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "quantity": 0,
      "timeToLive": {
        "sourceSystem": "string",
        "expirationDate": "2024-07-23T18:08:59.095Z",
        "isExpired": true
      },
      "title": "string",
      "unitPrice": 0,
      "unitQuantity": 0,
      "poLineNumber": "string",
      "isParentAsset": true,
      "targetAssetId": "string",
      "targetAssetType": "string",
      "assetPosSource": "string",
      "labelReference": "string",
      "assets": [
        {
          "isParentAsset": true,
          "targetAssetId": "string",
          "targetAssetType": "string",
          "assetPosSource": "string"
        }
      ],
      "cfiComments": [
        {
          "id": "string",
          "comment": "string",
          "code": "string",
          "isRequired": true,
          "minLength": 0,
          "maxLength": 0,
          "value": "string",
          "label": "string",
          "key": "string",
          "isHidden": true
        }
      ],
      "clearPriceEnabled": true,
      "callBacks": {
        "pricing": {
          "transact": "string"
        }
      },
      "catalogId": 0,
      "cfiProjectId": "string",
      "configRequest": "string",
      "configRequestUrl": "string",
      "configuredSelectionsUrl": "string",
      "txProductUrl": "string",
      "txShopPriceUrl": "string",
      "txMiscellaneousUrl": "string",
      "txValidationUrl": "string",
      "txRelationshipUrl": "string",
      "contract": {
        "contractCode": "string",
        "customerClassCode": "string",
        "isContractMandatory": true,
        "lineItemInvoicing": "string",
        "customerAgreementNumber": "string",
        "error": "string",
        "isValid": true,
        "isValidForCustomer": true,
        "isExpired": true,
        "isExpiringBeforeQuote": true,
        "endDate": "string",
        "dellPaysShippingMessage": "string",
        "dellPaysShippingMethod": "string",
        "contractName": "string"
      },
      "goalId": "string",
      "goalLineId": "string",
      "itemUrl": "string",
      "openBasketCompleteItemUrl": "string",
      "openBasketItemData": "string",
      "openBasketItemId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "openBasketItemUrl": "string",
      "openBasketLiteUrl": "string",
      "opportunityLineId": "string",
      "orderCode": "string",
      "pricingItemUrl": "string",
      "pricingOptionsSummaryUrl": "string",
      "pricingSummary": {
        "contractDiscountPercentage": 0,
        "contractPrice": 0,
        "discounts": [
          {
            "campaignId": "string",
            "description": "string",
            "discountAmount": 0,
            "expirationDate": "2024-07-23T18:08:59.095Z",
            "adjustmentType": "string",
            "adjustmentSubType": "string",
            "couponCode": "string"
          }
        ],
        "dol": 0,
        "dolPercentage": 0,
        "ecoFee": 0,
        "itemId": "string",
        "itemMarginPercentage": 0,
        "manualDiscountPercentage": 0,
        "manualDiscount": 0,
        "promotionsValue": 0,
        "promotionsPercentage": 0,
        "retailPrice": 0,
        "sellingPrice": 0,
        "salesTax": 0,
        "serviceContract": 0,
        "shippingAmount": 0,
        "shippingPriceDiscount": 0,
        "shippingManualDiscount": 0,
        "optionPriceSummary": [
          {
            "contractDiscountPercentage": 0,
            "contractPrice": 0,
            "discounts": [
              {
                "campaignId": "string",
                "description": "string",
                "discountAmount": 0,
                "expirationDate": "2024-07-23T18:08:59.095Z",
                "adjustmentType": "string",
                "adjustmentSubType": "string",
                "couponCode": "string"
              }
            ],
            "dol": 0,
            "dolPercentage": 0,
            "ecoFee": 0,
            "itemId": "string",
            "itemMarginPercentage": 0,
            "manualDiscountPercentage": 0,
            "manualDiscount": 0,
            "promotionsValue": 0,
            "promotionsPercentage": 0,
            "retailPrice": 0,
            "sellingPrice": 0,
            "salesTax": 0,
            "serviceContract": 0,
            "shippingAmount": 0,
            "shippingPriceDiscount": 0,
            "shippingManualDiscount": 0,
            "optionId": "string",
            "stateEnvFee": 0,
            "taxAmount": 0,
            "totalListPrice": 0,
            "totalMargin": 0,
            "totalAmount": 0,
            "totalCost": 0,
            "totalDiscountValue": 0,
            "totalDiscountPercent": 0,
            "unadjustedShippingAmount": 0,
            "unitCost": 0,
            "unitDiscountValue": 0,
            "unitDiscountPercentage": 0,
            "unitItemManualDiscount": 0,
            "unitMargin": 0,
            "unitMarginPercentage": 0,
            "unitPrice": 0,
            "unitSellingPrice": 0,
            "contractDiscount": 0,
            "taxableAmount": 0,
            "nonTaxableAmount": 0,
            "effectiveTaxRate": 0,
            "skuPriceSummary": [
              {
                "contractDiscountPercentage": 0,
                "contractPrice": 0,
                "discounts": [
                  {
                    "campaignId": "string",
                    "description": "string",
                    "discountAmount": 0,
                    "expirationDate": "2024-07-23T18:08:59.095Z",
                    "adjustmentType": "string",
                    "adjustmentSubType": "string",
                    "couponCode": "string"
                  }
                ],
                "dol": 0,
                "dolPercentage": 0,
                "ecoFee": 0,
                "skuId": "string",
                "itemId": "string",
                "itemMarginPercentage": 0,
                "manualDiscountPercentage": 0,
                "manualDiscount": 0,
                "promotionsValue": 0,
                "promotionsPercentage": 0,
                "retailPrice": 0,
                "sellingPrice": 0,
                "salesTax": 0,
                "serviceContract": 0,
                "shippingAmount": 0,
                "shippingPriceDiscount": 0,
                "shippingManualDiscount": 0,
                "skuNumber": "string",
                "serviceTagId": "string",
                "stateEnvFee": 0,
                "taxAmount": 0,
                "totalListPrice": 0,
                "totalMargin": 0,
                "totalAmount": 0,
                "totalCost": 0,
                "totalDiscountValue": 0,
                "totalDiscountPercent": 0,
                "unadjustedShippingAmount": 0,
                "unitCost": 0,
                "unitDiscountValue": 0,
                "unitDiscountPercentage": 0,
                "unitItemManualDiscount": 0,
                "unitMargin": 0,
                "unitMarginPercentage": 0,
                "unitPrice": 0,
                "unitSellingPrice": 0,
                "contractDiscount": 0,
                "taxableAmount": 0,
                "nonTaxableAmount": 0,
                "effectiveTaxRate": 0
              }
            ]
          }
        ],
        "optionLevelPriceSummaryUrl": "string",
        "skuPriceSummary": [
          {
            "contractDiscountPercentage": 0,
            "contractPrice": 0,
            "discounts": [
              {
                "campaignId": "string",
                "description": "string",
                "discountAmount": 0,
                "expirationDate": "2024-07-23T18:08:59.095Z",
                "adjustmentType": "string",
                "adjustmentSubType": "string",
                "couponCode": "string"
              }
            ],
            "dol": 0,
            "dolPercentage": 0,
            "ecoFee": 0,
            "skuId": "string",
            "itemId": "string",
            "itemMarginPercentage": 0,
            "manualDiscountPercentage": 0,
            "manualDiscount": 0,
            "promotionsValue": 0,
            "promotionsPercentage": 0,
            "retailPrice": 0,
            "sellingPrice": 0,
            "salesTax": 0,
            "serviceContract": 0,
            "shippingAmount": 0,
            "shippingPriceDiscount": 0,
            "shippingManualDiscount": 0,
            "skuNumber": "string",
            "serviceTagId": "string",
            "stateEnvFee": 0,
            "taxAmount": 0,
            "totalListPrice": 0,
            "totalMargin": 0,
            "totalAmount": 0,
            "totalCost": 0,
            "totalDiscountValue": 0,
            "totalDiscountPercent": 0,
            "unadjustedShippingAmount": 0,
            "unitCost": 0,
            "unitDiscountValue": 0,
            "unitDiscountPercentage": 0,
            "unitItemManualDiscount": 0,
            "unitMargin": 0,
            "unitMarginPercentage": 0,
            "unitPrice": 0,
            "unitSellingPrice": 0,
            "contractDiscount": 0,
            "taxableAmount": 0,
            "nonTaxableAmount": 0,
            "effectiveTaxRate": 0
          }
        ],
        "associatedItemPriceSummary": [
          "string"
        ],
        "stateEnvFee": 0,
        "taxAmount": 0,
        "totalListPrice": 0,
        "totalListPriceWithNonTiedItems": 0,
        "totalMargin": 0,
        "totalMarginWithNonTiedItems": 0,
        "totalMarginPercentWithNonTiedItems": 0,
        "totalAmount": 0,
        "totalCost": 0,
        "totalDiscountValue": 0,
        "totalDiscountPercent": 0,
        "unadjustedShippingAmount": 0,
        "unadjustedShippingAmountWithoutNonTiedItems": 0,
        "unitCost": 0,
        "unitDiscountValue": 0,
        "unitItemManualDiscount": 0,
        "unitDiscountPercentage": 0,
        "unitMargin": 0,
        "unitMarginPercentage": 0,
        "unitPrice": 0,
        "unitSellingPrice": 0,
        "contractDiscount": 0,
        "taxableAmount": 0,
        "nonTaxableAmount": 0,
        "effectiveTaxRate": 0,
        "taxInfo": [
          {
            "taxType": "string",
            "taxRate": 0
          }
        ]
      },
      "product": {
        "associatedItems": [
          "string"
        ],
        "associatedTiedItems": [
          {
            "unitQuantity": 0,
            "associatedItems": [
              "string"
            ],
            "associatedTiedItems": [
              "string"
            ],
            "associatedItemsUrl": "string",
            "baseSkuClass": "string",
            "baseSkuClassDescription": "string",
            "baseSkuNumber": "string",
            "brandId": "string",
            "buildToStock": true,
            "catalogId": 0,
            "categories": [
              {
                "name": "string",
                "id": "string",
                "parentCategoryId": "string",
                "description": "string"
              }
            ],
            "category": "string",
            "cfiComments": [
              {
                "id": "string",
                "comment": "string",
                "code": "string",
                "isRequired": true,
                "minLength": 0,
                "maxLength": 0,
                "value": "string",
                "label": "string",
                "key": "string",
                "isHidden": true
              }
            ],
            "chassisId": 0,
            "configItemType": "string",
            "csSiNumber": "string",
            "customerSpecificFields": {
              "additionalProp1": "string",
              "additionalProp2": "string",
              "additionalProp3": "string"
            },
            "description": "string",
            "externalName": "string",
            "extendedProperties": {
              "additionalProp1": "string",
              "additionalProp2": "string",
              "additionalProp3": "string"
            },
            "familyId": "string",
            "groupId": "string",
            "id": "string",
            "image": "string",
            "inventoryStatus": "string",
            "isDellwareOnly": true,
            "isLicensingProduct": true,
            "isSeItem": true,
            "isTiedSku": true,
            "lobId": "string",
            "manufacturerId": "string",
            "manufacturerName": "string",
            "orderCode": "string",
            "productLineId": 0,
            "quantity": 0,
            "serviceTag": "string",
            "serviceTags": [
              {
                "expirationDate": "2024-07-23T18:08:59.095Z",
                "id": "string",
                "startDate": "2024-07-23T18:08:59.095Z",
                "totalPrice": 0,
                "listPrice": 0,
                "aposSkus": [
                  {
                    "id": "string",
                    "description": "string",
                    "listPrice": 0,
                    "contractEndDate": "2024-07-23T18:08:59.095Z",
                    "originalDurationinDays": 0,
                    "contractStartDate": "2024-07-23T18:08:59.095Z",
                    "serviceLevelCode": "string",
                    "validationResult": {
                      "isValid": true
                    },
                    "serviceLifeDurationDays": 0,
                    "metaData": [
                      {
                        "key": "string",
                        "value": "string"
                      }
                    ]
                  }
                ],
                "contractSummary": [
                  {
                    "serviceLevelCode": "string",
                    "contractStatus": "string",
                    "contractType": "string",
                    "proSupportType": "string",
                    "currentContractStartDate": "string",
                    "currentContractEndDate": "string",
                    "newContractStartDate": "string",
                    "newContractEndDate": "string"
                  }
                ],
                "shipDate": "2024-07-23T18:08:59.095Z"
              }
            ],
            "sku": "string",
            "skus": [
              {
                "allowMultiQuantity": true,
                "contractLaborCode": "string",
                "currentDuration": 0,
                "customFields": {
                  "additionalProp1": "string",
                  "additionalProp2": "string",
                  "additionalProp3": "string"
                },
                "description": "string",
                "discountClass": "string",
                "duration": 0,
                "durationDays": 0,
                "durationMonths": 0,
                "isCfi": true,
                "isServiceSku": true,
                "isTied": true,
                "isVariable": true,
                "isVariablePriced": true,
                "lobId": "string",
                "moduleDescription": "string",
                "optionDescription": "string",
                "optionQuantity": 0,
                "parentModuleId": "string",
                "parentModuleName": "string",
                "parentOptionId": "string",
                "parentOptionName": "string",
                "placedPrice": 0,
                "quantity": 0,
                "serviceType": "string",
                "skuClass": "string",
                "skuNumber": "string",
                "status": "string",
                "subscriptionInformation": {
                  "id": "string",
                  "name": "string",
                  "renewalAmount": 0,
                  "skuId": "string",
                  "productType": "string",
                  "cadence": "string",
                  "subscriptionServiceType": "string",
                  "serviceLifeDurationDays": "string",
                  "flexBillingMaxDuration": "string"
                },
                "weight": 0,
                "parentItemTypeCode": "string",
                "itemTypeCode": "string",
                "fulfillmentLocation": "string",
                "serviceLevelCode": "string",
                "rollupFlag": true,
                "isFlexi": true,
                "attributes": [
                  {
                    "id": "string",
                    "value": "string"
                  }
                ]
              }
            ],
            "status": "string",
            "type": "OrderCode",
            "unspcCode": "string",
            "weight": 0,
            "contractDescription": "string",
            "contractCode": "string",
            "allowChangeQuantity": true,
            "familyName": "string",
            "shipsWith": true,
            "lease": {
              "disposition": "string",
              "expensedTotal": 0,
              "frequency": "string",
              "lrf": 0,
              "leaseDetail": "string",
              "leaseTerms": "string"
            },
            "nonVariableListPrice": 0,
            "snpDeliveryMessageId": 0,
            "mfgPartNumber": "string",
            "isVariablePriced": true,
            "validationResult": {
              "isValid": true
            },
            "taaComplianceStatus": {},
            "customFields": {
              "additionalProp1": "string",
              "additionalProp2": "string",
              "additionalProp3": "string"
            },
            "isPCaaSItem": true,
            "buyerPartNumber": "string",
            "modules": [
              {
                "id": 0,
                "options": [
                  {
                    "id": "string",
                    "vpn": "string",
                    "description": "string",
                    "optionPricing": {
                      "value": 0
                    }
                  }
                ]
              }
            ],
            "parentItemId": "string",
            "attributes": [
              {
                "id": "string",
                "value": "string"
              }
            ],
            "productDetailUrl": "string",
            "opportunityLineId": "string",
            "specialPricingAuthId": "string"
          }
        ],
        "associatedItemsUrl": "string",
        "baseSkuClass": "string",
        "baseSkuClassDescription": "string",
        "baseSkuNumber": "string",
        "brandId": "string",
        "buildToStock": true,
        "catalogId": 0,
        "categories": [
          {
            "name": "string",
            "id": "string",
            "parentCategoryId": "string",
            "description": "string"
          }
        ],
        "category": "string",
        "cfiComments": [
          {
            "id": "string",
            "comment": "string",
            "code": "string",
            "isRequired": true,
            "minLength": 0,
            "maxLength": 0,
            "value": "string",
            "label": "string",
            "key": "string",
            "isHidden": true
          }
        ],
        "chassisId": 0,
        "configItemType": "string",
        "csSiNumber": "string",
        "customerSpecificFields": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "description": "string",
        "externalName": "string",
        "extendedProperties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "familyId": "string",
        "groupId": "string",
        "id": "string",
        "image": "string",
        "inventoryStatus": "string",
        "isDellwareOnly": true,
        "isLicensingProduct": true,
        "isSeItem": true,
        "isTiedSku": true,
        "lobId": "string",
        "manufacturerId": "string",
        "manufacturerName": "string",
        "orderCode": "string",
        "productLineId": 0,
        "quantity": 0,
        "serviceTag": "string",
        "serviceTags": [
          {
            "expirationDate": "2024-07-23T18:08:59.095Z",
            "id": "string",
            "startDate": "2024-07-23T18:08:59.095Z",
            "totalPrice": 0,
            "listPrice": 0,
            "aposSkus": [
              {
                "id": "string",
                "description": "string",
                "listPrice": 0,
                "contractEndDate": "2024-07-23T18:08:59.095Z",
                "originalDurationinDays": 0,
                "contractStartDate": "2024-07-23T18:08:59.095Z",
                "serviceLevelCode": "string",
                "validationResult": {
                  "isValid": true
                },
                "serviceLifeDurationDays": 0,
                "metaData": [
                  {
                    "key": "string",
                    "value": "string"
                  }
                ]
              }
            ],
            "contractSummary": [
              {
                "serviceLevelCode": "string",
                "contractStatus": "string",
                "contractType": "string",
                "proSupportType": "string",
                "currentContractStartDate": "string",
                "currentContractEndDate": "string",
                "newContractStartDate": "string",
                "newContractEndDate": "string"
              }
            ],
            "shipDate": "2024-07-23T18:08:59.095Z"
          }
        ],
        "sku": "string",
        "skus": [
          {
            "allowMultiQuantity": true,
            "contractLaborCode": "string",
            "currentDuration": 0,
            "customFields": {
              "additionalProp1": "string",
              "additionalProp2": "string",
              "additionalProp3": "string"
            },
            "description": "string",
            "discountClass": "string",
            "duration": 0,
            "durationDays": 0,
            "durationMonths": 0,
            "isCfi": true,
            "isServiceSku": true,
            "isTied": true,
            "isVariable": true,
            "isVariablePriced": true,
            "lobId": "string",
            "moduleDescription": "string",
            "optionDescription": "string",
            "optionQuantity": 0,
            "parentModuleId": "string",
            "parentModuleName": "string",
            "parentOptionId": "string",
            "parentOptionName": "string",
            "placedPrice": 0,
            "quantity": 0,
            "serviceType": "string",
            "skuClass": "string",
            "skuNumber": "string",
            "status": "string",
            "subscriptionInformation": {
              "id": "string",
              "name": "string",
              "renewalAmount": 0,
              "skuId": "string",
              "productType": "string",
              "cadence": "string",
              "subscriptionServiceType": "string",
              "serviceLifeDurationDays": "string",
              "flexBillingMaxDuration": "string"
            },
            "weight": 0,
            "parentItemTypeCode": "string",
            "itemTypeCode": "string",
            "fulfillmentLocation": "string",
            "serviceLevelCode": "string",
            "rollupFlag": true,
            "isFlexi": true,
            "attributes": [
              {
                "id": "string",
                "value": "string"
              }
            ]
          }
        ],
        "status": "string",
        "type": "OrderCode",
        "unspcCode": "string",
        "weight": 0,
        "contractDescription": "string",
        "contractCode": "string",
        "allowChangeQuantity": true,
        "familyName": "string",
        "shipsWith": true,
        "lease": {
          "disposition": "string",
          "expensedTotal": 0,
          "frequency": "string",
          "lrf": 0,
          "leaseDetail": "string",
          "leaseTerms": "string"
        },
        "nonVariableListPrice": 0,
        "snpDeliveryMessageId": 0,
        "mfgPartNumber": "string",
        "isVariablePriced": true,
        "validationResult": {
          "isValid": true
        },
        "taaComplianceStatus": {},
        "customFields": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "isPCaaSItem": true,
        "buyerPartNumber": "string",
        "modules": [
          {
            "id": 0,
            "options": [
              {
                "id": "string",
                "vpn": "string",
                "description": "string",
                "optionPricing": {
                  "value": 0
                }
              }
            ]
          }
        ],
        "parentItemId": "string",
        "attributes": [
          {
            "id": "string",
            "value": "string"
          }
        ],
        "productDetailUrl": "string",
        "opportunityLineId": "string",
        "unitQuantity": 0,
        "specialPricingAuthId": "string"
      },
      "reservationSnapshotUrl": "string",
      "sku": "string",
      "smartPriceUrl": "string",
      "splittingItemsUrl": "string",
      "type": "OrderCode",
      "validations": [
        {
          "source": "string",
          "itemId": "string",
          "message": "string",
          "messageCode": "string",
          "severity": "Info",
          "category": "string",
          "subCategory": "string"
        }
      ],
      "extendedProperties": [
        {
          "key": "string",
          "namespace": "string",
          "value": "string"
        }
      ],
      "customerSpecificFields": [
        {
          "fieldKey": "string",
          "fieldValue": "string",
          "nameSpace": "string"
        }
      ],
      "eTag": "string",
      "metadata": [
        {
          "id": "string",
          "node": {
            "id": "string",
            "type": "string",
            "child": "string",
            "customFields": [
              {
                "key": "string",
                "value": "string"
              }
            ]
          }
        }
      ],
      "configuredSelections": "string",
      "requiresRefresh": true,
      "updateConfigRequest": true,
      "updateConfiguredSelections": true,
      "removeFocAdjustment": true,
      "selectedOptionsOnly": true,
      "isRenewableFlexbillingItem": true,
      "itemContract": {
        "contractCode": "string",
        "contractType": "string"
      },
      "clearPriceProgramInfo": [
        {
          "serviceTag": "string",
          "pricingProgram": "string"
        }
      ]
    }
  ],
  "shipments": [
    {
      "id": "string",
      "shipmentName": "string",
      "shippingMethod": "string",
      "shippingOptions": [
        "string"
      ],
      "shippingContact": {
        "firstName": "string",
        "middleName": "string",
        "lastName": "string",
        "prefix": "string",
        "suffix": "string",
        "title": "string",
        "companyName": "string",
        "customerNumber": "string",
        "department": "string",
        "emailAddress": "string",
        "warrantyEmail": "string",
        "digitalFulfillmentEmail": "string",
        "phoneContacts": [
          {
            "countryCode": "string",
            "areaCode": "string",
            "number": "string",
            "extension": "string",
            "phoneType": "Work"
          }
        ],
        "fax": {
          "countryCode": "string",
          "areaCode": "string",
          "number": "string",
          "extension": "string",
          "phoneType": "Work"
        },
        "camId": "string",
        "camLocationId": "string",
        "address": {
          "city": "string",
          "cityCode": "string",
          "country": "string",
          "countryCode": 0,
          "domsSequenceNumber": "string",
          "id": "string",
          "line1": "string",
          "line2": "string",
          "line3": "string",
          "line4": "string",
          "line5": "string",
          "other1": "string",
          "other2": "string",
          "other3": "string",
          "other4": "string",
          "other5": "string",
          "postalCode": "string",
          "region": "string",
          "regionName": "string",
          "suburb": "string"
        },
        "optInFlags": true,
        "additionalEmails": [
          {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          }
        ],
        "taxIdPrimary": "string",
        "taxIdSecondary": "string",
        "taxCategory": "string",
        "ucid": "string",
        "organizationInfo": {
          "branchName": "string",
          "department": "string",
          "id": "string",
          "name": "string",
          "secondaryName": "string",
          "taxNo": "string",
          "title": "string",
          "type": "string"
        },
        "secondaryName": {
          "first": "string",
          "last": "string",
          "maGuid": "string",
          "mi": "string",
          "prefix": "string",
          "suffix": "string",
          "title": "string"
        },
        "marketingPreferences": {
          "additionalProp1": true,
          "additionalProp2": true,
          "additionalProp3": true
        },
        "shipToTaxCategory": "string",
        "invoiceType": "string",
        "taxRegNo": "string",
        "bankName": "string",
        "accountNumber": "string",
        "accountType": "string",
        "carrierType": "string",
        "carrierID": "string",
        "cpfGroupId": "string",
        "accountName": "string",
        "invoiceDeliveryMethod": "string",
        "language": "string",
        "properties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "compliance": {
          "taxRegime": "string",
          "eInvoiceFormat": "string",
          "taxRegimeDesc": "string",
          "eInvoiceFormatDesc": "string"
        }
      },
      "designatedCarrier": {
        "preferredCarrier": "string",
        "accountNumber": "string",
        "deliveryMethod": "string",
        "deliveryMethodDesc": "string"
      },
      "contactReferences": [
        {
          "id": "string",
          "resourceReference": {
            "eTag": "string",
            "schema": "string",
            "sourceSystem": "string",
            "location": "string"
          },
          "type": "string",
          "optOut": "string"
        }
      ],
      "items": [
        {
          "quoteItemId": "string",
          "estimatedShippingDate": "2024-07-23T18:08:59.095Z",
          "estimatedDeliveryDate": "2024-07-23T18:08:59.096Z",
          "estimatedShippingDateRange": {
            "min": "2024-07-23T18:08:59.096Z",
            "max": "2024-07-23T18:08:59.096Z"
          },
          "estimatedDeliveryDateRange": {
            "min": "2024-07-23T18:08:59.096Z",
            "max": "2024-07-23T18:08:59.096Z"
          },
          "arriveByDate": "2024-07-23T18:08:59.096Z",
          "isFuture": true,
          "shipFromState": "string",
          "siteCode": "string",
          "estimatedServiceActivationDateRange": {
            "min": "2024-07-23T18:08:59.096Z",
            "max": "2024-07-23T18:08:59.096Z"
          },
          "isDirectShip": true,
          "vendorId": "string",
          "inboundShipMethod": "string",
          "inboundShipmentName": "string"
        }
      ],
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "instructions": "string",
      "installationInstructions": "string",
      "priceSummary": {
        "shipmentId": "string",
        "shippingPrice": 0,
        "totalShipping": 0,
        "shippingDiscount": 0,
        "subTotal": 0,
        "totalTax": 0,
        "ecoFees": 0,
        "totalAmount": 0,
        "shippingTax": 0,
        "adjustedShipping": 0,
        "shippingManualDiscount": 0,
        "discounts": [
          {
            "campaignId": "string",
            "description": "string",
            "discountAmount": 0,
            "expirationDate": "2024-07-23T18:08:59.096Z",
            "adjustmentType": "string",
            "adjustmentSubType": "string",
            "couponCode": "string"
          }
        ]
      },
      "itemGroupId": "string",
      "consolidationId": "string",
      "consolidationQuantity": 0,
      "consolidationItemQuantity": 0,
      "futuristicDeliveryDate": "2024-07-23T18:08:59.096Z",
      "groupName": "string",
      "groupId": "string",
      "goalId": "string",
      "arriveByDate": "2024-07-23T18:08:59.096Z",
      "anESolutionName": "string",
      "agreementId": "string",
      "incoTerms": "string",
      "incoTermsDesc": "string",
      "shippingCarrier": "string",
      "deliveryCity": "string",
      "fgaType": "string",
      "fgaTypeDesc": "string",
      "isUpgrade": true,
      "byPassShipmentSplit": true,
      "vatpNotes": "string",
      "licenseManagerEmails": [
        "string"
      ]
    }
  ],
  "properties": {
    "additionalProp1": "string",
    "additionalProp2": "string",
    "additionalProp3": "string"
  },
  "customCheckOutFields": [
    {
      "id": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      }
    }
  ],
  "customerSpecificFields": [
    {
      "fieldKey": "string",
      "fieldValue": "string",
      "nameSpace": "string"
    }
  ],
  "extendedProperties": {
    "additionalProp1": "string",
    "additionalProp2": "string",
    "additionalProp3": "string"
  },
  "customSkuPricing": true,
  "priceStoreUrl": "string",
  "priceStoreData": "string",
  "priceReportingViewUrl": "string",
  "priceShippingViewUrl": "string",
  "priceSummaryUrl": "string",
  "priceViewUrl": "string",
  "priceDetailViewUrl": "string",
  "priceRequestUrl": "string",
  "clearPrice": {
    "eTag": "string",
    "schema": "string",
    "rel": "string",
    "ref": "string"
  },
  "references": [
    {
      "referenceId": "string",
      "referenceType": "Unknown",
      "referencedOn": "2024-07-23T18:08:59.096Z",
      "referenceCreatedBy": "string",
      "targetSystem": "string",
      "target": "string",
      "version": "string",
      "targetSystemStatus": "string"
    }
  ],
  "validations": [
    {
      "source": "string",
      "itemId": "string",
      "message": "string",
      "messageCode": "string",
      "severity": "Info",
      "category": "string",
      "subCategory": "string"
    }
  ],
  "isUpgrade": true,
  "upgrade": {
    "optoutReasonCode": "string"
  },
  "resellerException": "string",
  "fraudPrevention": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "tradeCompliance": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "referralCode": "string",
  "marketingSource": "string",
  "sfdcCaseNumber": "string",
  "sfdcEmailReferenceNumber": "string",
  "dps": "string",
  "tags": {
    "additionalProp1": [
      "string"
    ],
    "additionalProp2": [
      "string"
    ],
    "additionalProp3": [
      "string"
    ]
  },
  "itemRelationships": "string",
  "lastModifiedBy": "string",
  "opportunityId": "string",
  "frameworkDealId": "string",
  "createdBy": "string",
  "businessContext": {
    "sourceApplicationName": "string",
    "originalSourceApplicationName": "string",
    "accessGroup": "string",
    "companyNumber": "string",
    "country": "string",
    "currency": "string",
    "catalogToCurrencyHedgeRate": 0,
    "multiCurrency": [
      {
        "currencyCode": "string",
        "exchangeRate": 0
      }
    ],
    "displayCurrency": "string",
    "customerSet": "string",
    "language": "string",
    "region": "string",
    "segment": "string",
    "businessUnitId": "string",
    "registrationId": "string",
    "pricingRegistrationIdsForTypes": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "destinationSystem": "string",
    "sellingEntity": "string",
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "customerAccountId": 0,
    "classCode": "string",
    "cdcEnabled": true,
    "queueCode": "string",
    "profile": {
      "partyId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "updateProfileInfo": true,
      "personId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "accountId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "orgId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "relationId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "role": "string",
      "pageId": "string",
      "icuCustomerId": "string",
      "accountName": "string"
    },
    "isGlobalPortal": true,
    "useReseller": true,
    "band": 0,
    "isGop": true
  },
  "customer": {
    "id": "string",
    "name": "string",
    "status": "string",
    "accountId": "string",
    "customerNumber": "string",
    "company": {
      "name": "string",
      "telephone": {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "extension": "string",
        "phoneType": "Work"
      },
      "fax": {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "extension": "string",
        "phoneType": "Work"
      },
      "number": "string"
    },
    "language": "string",
    "omsCustomerId": "string"
  },
  "pricingSummary": {
    "listPrice": 0,
    "sellingPrice": 0,
    "costPrice": 0,
    "discountPercentage": 0,
    "discountValue": 0,
    "discounts": [
      {
        "campaignId": "string",
        "description": "string",
        "discountAmount": 0,
        "expirationDate": "2024-07-23T18:08:59.096Z",
        "adjustmentType": "string",
        "adjustmentSubType": "string",
        "couponCode": "string"
      }
    ],
    "compRevenue": 0,
    "totalMarginValue": 0,
    "marginPercentage": 0,
    "subTotal": 0,
    "shippingAmountBeforeDiscount": 0,
    "shippingAmount": 0,
    "shippingDiscountAmount": 0,
    "shippingManualDiscount": 0,
    "shippingTax": 0,
    "adjustedShipping": 0,
    "totalTax": 0,
    "taxAndShippingTax": 0,
    "ecoFee": 0,
    "finalPrice": 0,
    "damMarginVariance": 0,
    "damDiscountVariance": 0,
    "totalDamDiscountVariancePercentage": 0,
    "totalDamMarginVariancePercentage": 0,
    "taxableAmount": 0,
    "nonTaxableAmount": 0,
    "effectiveTaxRate": 0,
    "taxInfo": [
      {
        "taxType": "string",
        "taxRate": 0
      }
    ]
  },
  "contract": {
    "contractCode": "string",
    "customerClassCode": "string",
    "isContractMandatory": true,
    "lineItemInvoicing": "string",
    "customerAgreementNumber": "string",
    "error": "string",
    "isValid": true,
    "isValidForCustomer": true,
    "isExpired": true,
    "isExpiringBeforeQuote": true,
    "endDate": "string",
    "dellPaysShippingMessage": "string",
    "dellPaysShippingMethod": "string",
    "contractName": "string"
  },
  "taxInformation": {
    "taxOverrideRate": 0,
    "isTaxOverrideEnabled": true,
    "isStateTaxIncluded": true,
    "category": "string",
    "isExempt": true,
    "taxExemptCode": "string",
    "taxOverrideFlag": "string",
    "taxOverrideReasonCode": "string",
    "defaultStateForTaxCalculation": "string",
    "isRequired": true,
    "primaryTaxId": "string",
    "exemptTaxType": "string"
  },
  "salesReps": [
    {
      "id": "string",
      "salesPersonNumber": 0,
      "employeeId": "string",
      "firstname": "string",
      "lastname": "string",
      "middleInitial": "string",
      "email": "string",
      "salesRepType": "Secondary",
      "phone": {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "extension": "string",
        "phoneType": "Work"
      },
      "hasSmartPriceRights": true
    }
  ],
  "installationInstructions": "string",
  "coupons": [
    {
      "couponCode": "string"
    }
  ],
  "promotions": [
    {
      "campaignExclusionId": 0,
      "description": "string"
    }
  ],
  "isSmb": true,
  "paymentMethods": [
    {
      "id": "string",
      "billPlanId": "string",
      "amount": 0,
      "isRecurring": true,
      "paymentCode": "string",
      "netTerm": "string",
      "payerName": "string",
      "payeeAmount": 0,
      "globalPaymentID": "string",
      "description": "string",
      "type": "string",
      "creditCardType": "string",
      "creditRating": 0,
      "isPrepaid": true,
      "isLease": true,
      "leaseAgreementNumber": "string",
      "paymentReceiptNumber": "string",
      "referenceNumber": "string",
      "originalOrderNumber": "string",
      "isInterestApplied": true,
      "emiAmountExcludingInstallmentCharges": 0,
      "emiAmountPerInstallment": 0,
      "emiNumberOfInstallments": 0,
      "extendedProperties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "isTaxExempted": true
    }
  ],
  "poNumber": "string",
  "type": "string",
  "solutionId": "string",
  "solutionVersion": "string",
  "solutionRegion": "string",
  "solutionGroupId": "string",
  "solutionRequestOrigin": "string",
  "state": "string",
  "pomId": "string",
  "linkId": "string",
  "price": {
    "smartPriceUrl": "string"
  },
  "connections": [
    {
      "itemIds": [
        "string"
      ],
      "parentOpenBasketId": "string",
      "quantity": 0,
      "unitQuantity": 0,
      "childItems": [
        {
          "openBasketId": "string",
          "quantity": 0
        }
      ]
    }
  ],
  "priceAdjustments": [
    {
      "id": "string",
      "isTaxInclusive": true,
      "expirationTime": "2024-07-23T18:08:59.096Z",
      "value": 0,
      "type": "Amount",
      "scope": "Local",
      "targetLevel": "AllItems",
      "targetId": "string",
      "isRedemptionAdjustment": true,
      "targetParentHierarchy": {
        "id": "string",
        "type": "string",
        "child": "string"
      },
      "isQuantityInclusive": true,
      "additionalInfo": [
        {
          "key": "string",
          "value": "string"
        }
      ],
      "isEcofeeInclusivePrice": true
    }
  ],
  "skuPriceAdjustments": [
    {
      "id": "string",
      "itemId": "string",
      "serviceTagId": "string",
      "targetParentHierarchy": {
        "id": "string",
        "type": "string",
        "child": "string"
      },
      "listPrice": 0,
      "cost": 0,
      "discount": {
        "type": "Amount",
        "value": 0
      }
    }
  ],
  "orderType": "string",
  "endUserInfo": {
    "id": "string",
    "requestId": "string",
    "requestStatus": "string",
    "customerAccountId": "string",
    "omsCustomerId": "string",
    "salesChannelId": "string",
    "partyId": "string"
  },
  "cfo": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "cfoPreferences": [
    {
      "cfoTypes": [
        "string"
      ],
      "language": "string",
      "format": "string",
      "method": "string",
      "sendCfo": true,
      "toRecipients": "string",
      "ccRecipients": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      }
    }
  ],
  "customerPrivacy": {
    "shareTelephonewithCarrier": true,
    "hideBillTo": true,
    "deliveryNoteWithPrice": true
  },
  "fulfillmentsLookupId": "string",
  "poReceivedDate": "2024-07-23T18:08:59.096Z",
  "bypassSplittingRules": true,
  "legacyQuoteId": "string",
  "contacts": [
    {
      "id": "string",
      "resourceReference": {
        "eTag": "string",
        "schema": "string",
        "sourceSystem": "string",
        "location": "string"
      },
      "type": "string",
      "optOut": "string"
    }
  ],
  "snapshotReferences": [
    {
      "id": "string",
      "resourceReference": {
        "eTag": "string",
        "schema": "string",
        "sourceSystem": "string",
        "location": "string"
      },
      "type": "string"
    }
  ],
  "isTLACrossBorder": true,
  "resellerMarkup": "string",
  "isBuildProhibited": true,
  "holdReasons": [
    {
      "key": "string",
      "code": "string"
    }
  ],
  "donationCode": "string",
  "smartPrice": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "isCpf": true,
  "largeTransaction": true,
  "contracts": [
    {
      "id": "string",
      "contractCode": "string",
      "customerClassCode": "string",
      "lineItemInvoicing": "string",
      "customerAgreementNumber": "string",
      "endDate": "string",
      "dellPaysShippingMessage": "string",
      "dellPaysShippingMethod": "string",
      "contractName": "string",
      "contractType": "string",
      "paymentTerms": "string",
      "sellingEntity": "string",
      "legacyContractCode": "string",
      "hasProductRestrictions": true,
      "gsaCompliant": "string",
      "taaCompliant": "string"
    }
  ],
  "secondaryPoNumber": "string"
}
```

# DPID
### G4
GET TSO from DPID: 7040000330593 - Apr 2023
##### Example1
```json
{
    "osemHeader": {
        "version": "1.0"
    },
    "orderDomain": {
        "resource": {
            "version": null,
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/order/7040000330593"
        },
        "data": {
            "correlationId": null,
            "dpid": "7040000330593",
            "cmcId": null,
            "wbseIds": null,
            "xaaSEvalOrderDpid": null,
            "referenceOrderDPID": null,
            "orderStatus": "BKD",
            "dispositionCode": "CMP",
            "dpidCMPDate": "2023-05-04T13:24:02.434419Z",
            "version": "1",
            "isActiveDPID": true,
            "poNum": "Test123",
            "salesOfferType": null,
            "agreementCategory": null,
            "isXaasFo": null,
            "isXaasCo": null,
            "ratableFlag": null,
            "eQuoteSource": null,
            "eQuoteNumber": null,
            "conditionalSales": null,
            "id": "qWqMNHjsEUOKpHvSmgugYA~002",
            "udid": null,
            "sellingEntity": null,
            "isUpgrade": false,
            "isInstallationRequired": null,
            "createdOn": "0001-01-01T00:00:00Z",
            "solutionId": null,
            "solutionVersion": null,
            "solutionRegion": null,
            "installationInstructions": null,
            "destinationSystemOverride": null,
            "originalQuoteNumber": null,
            "billingBUID": null,
            "shippingBUID": null,
            "billingSalesChannel": null,
            "shippingSalesChannel": null,
            "asnChannelEnabled": null,
            "asnEnabled": null,
            "pocEnabled": null,
            "b2BEnvironment": null,
            "isRelationship": null,
            "secondaryID": null,
            "quoteTypeForQuoteViewer": null,
            "isChannelServiceCard": "N",
            "cartType": null,
            "allowValidationErrors": null,
            "billFirstCycleAdvance": null,
            "cfiAdminOverride": null,
            "boeCategory": null,
            "boeNumber": null,
            "shippingChangesInCheckout": null,
            "enableInternationalCheckoutForCoNum20": null,
            "latamIndirectGlobalPortalCountry": null,
            "customerReviewOrder": null,
            "pomID": null,
            "invoiceCustomization": "",
            "coRefNumber": null,
            "stealthMode": null,
            "partnerFlag": null,
            "partnerTrack": null,
            "salesMotion": null,
            "trialEnabled": null,
            "partnerProgramTrack": null,
            "isTLACrossBorder": false,
            "donationCode": null,
            "noOfInstallments": null,
            "noCostEmiOrderDiscount": null,
            "monthlyEMIAmount": null,
            "originalOrderTotal": null,
            "opportunityID": null,
            "resellerMarkup": null,
            "quoteType": null,
            "quotedDate": "0001-01-01T00:00:00+00:00",
            "dps": null,
            "sfdcCaseNumber": null,
            "sfdcEmailReferenceNumber": null,
            "isPartialReturn": null,
            "buyOrderOriginalOrderNumber": null,
            "frameworkDealID": null,
            "originalCustomerSet": null,
            "totalAmount": 2844.45,
            "endUserCustomerName": "OSTT-TEST",
            "solutionGroupId": null,
            "installationDetails": null,
            "orderConfirmationFlag": false,
            "orderConfirmationFormat": null,
            "tlaAttributes": [],
            "isCommercial": false,
            "isDtcpQuote": false,
            "cfiRegionCode": null,
            "cfiBusinessUnitID": null,
            "cfiCompanyNumber": null,
            "cfiSalesChannel": null,
            "cfiValidateForCustomerAndChassis": false,
            "referenceOrderNumber": null,
            "holdsInput": null,
            "isGcmpChkBulkOrder": null,
            "rePlacedDpid": null,
            "linkToCancelledOrderDpid": null,
            "linkToReEnteredOrderDpid": null,
            "serviceTags": [],
            "orderHolds": [
                {
                    "orderHoldId": "7f8e8578-171c-4ed9-8f49-386d45b1d3ae",
                    "holdId": "ffe9de70-1780-45f5-8e34-44f15456d7b4",
                    "holdName": "CustomerSystemPendingHold",
                    "dpId": "7040000330593",
                    "holdDescription": "CustomerSystemPendingHold :: UK :: PLEASE DO NOT RESUBMIT. Order has been placed on Hold temporarily while the customer validation is underway. Order will be released once the processing is completed.  Systematic validation in progress, will auto-release. If still on hold after 24 hours, you can submit a <a href='https://dcsf.my.site.com/SalesSupport/s/RaiseSupport' target='_blank'>Sales Support Case</a> for IT support to advise status.",
                    "domainName": "customerDomainContext",
                    "holdCreatedTime": "2023-05-04T13:21:26.1724265Z",
                    "isRelased": true,
                    "releasedTime": "2023-05-04T13:21:29.2832013Z",
                    "releaseCreator": "OMCS_Customer",
                    "releaseDescription": "Customer process is success without any errors",
                    "holdCategory": "System",
                    "isReleasable": false
                },
                {
                    "orderHoldId": "ecede313-db3d-461a-b0ff-fed32c4082f6",
                    "holdId": "a31058f9-1317-49e2-b4f6-c123f21a185e",
                    "holdName": "GaftCheckHold",
                    "dpId": "7040000330593",
                    "holdDescription": "GaftCheckHold :: UK :: GCD-001: Standard Global Anti-Fraud review, release is automated. Do not submit FSR if on hold less than 24 hours. Hold Inquiry: <a href='https://u1vmfsrprodapp1.aus.amer.dell.com/FSR/CreateRequest?FId=1156'>https://u1vmfsrprodapp1.aus.amer.dell.com/FSR/CreateRequest?FId=1156</a>",
                    "domainName": "omcsDomainContext",
                    "holdCreatedTime": "2023-05-04T13:21:49.8759853Z",
                    "isRelased": true,
                    "releasedTime": "2023-05-04T13:21:55.182067Z",
                    "releaseCreator": "OMCS.Global.Compliance.Gaft.Receiver",
                    "releaseDescription": "Response contains RELEASE result from GAFT",
                    "holdCategory": "Business",
                    "isReleasable": false
                },
                {
                    "orderHoldId": "e63dad3d-adec-40be-ab74-8de271784061",
                    "holdId": "0d2a8d87-8afd-449b-b68c-26028dc49a88",
                    "holdName": "TradeComplianceValidatorHold",
                    "dpId": "7040000330593",
                    "holdDescription": "TradeComplianceValidatorHold :: UK :: TradeComplianceValidatorHold :: Standard Trade Compliance HOLD, release is automated. Do not submit Fusion if on hold less than 24 hours. For Inquiry contact relevant team: APJ:Trade_Compliance_Solutions_AP@Dell.com, EMEA:MCIS_AP@Dell.com, CN/HK:CNXMNTradeCompliance@Dell.com, JP:jptcscreening@dell.com",
                    "domainName": "complianceDomainContext",
                    "holdCreatedTime": "2023-05-04T13:21:58.838106Z",
                    "isRelased": true,
                    "releasedTime": "2023-05-04T13:22:30.6437767Z",
                    "releaseCreator": "OMCS.Global.Compliance.Tc.Receiver",
                    "releaseDescription": "Response contains OPEN result from GTM",
                    "holdCategory": "Business",
                    "isReleasable": false
                }
            ],
            "clientRequestedHold": null,
            "businessContext": {
                "region": "emea",
                "buid": "202",
                "country": "UK",
                "companyNumber": "ENTP",
                "customerSet": "rc1506172",
                "segment": "ENT",
                "language": "en",
                "backendLanguageCode": "",
                "currency": "GBP",
                "originalSourceApplicationName": null,
                "sourceApplicationName": "OLRGCOMM",
                "customerID": null,
                "discount": null,
                "customerAccountID": "0",
                "channelId": "15621",
                "departmentCode": "UKBSDTOF",
                "queueCode": "UKETS",
                "destinationSystem": "OMGEM",
                "isGlobalPortal": false,
                "isGop": true,
                "omsCustomerId": null,
                "accessGroup": "ab0e50aa-5fce-4cc0-bc8d-adf2010a663e",
                "useReseller": false,
                "band": 0,
                "classCode": "GB_UKDU",
                "cdcEnabled": false,
                "profile": {
                    "partyId": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                    "updateProfileInfo": false,
                    "personId": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                    "accountId": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                    "orgId": "00000000-0000-0000-0000-000000000000",
                    "relationId": "00000000-0000-0000-0000-000000000000",
                    "role": null,
                    "pageId": "822014",
                    "icuCustomerId": null,
                    "accountName": "###TEST_GOP_UK_MB"
                },
                "browserIP": "10.179.160.26",
                "poReceivedDate": "2023-05-04T13:19:44Z",
                "taxInformation": {
                    "taxOverrideRate": null,
                    "overrideAllTaxType": false,
                    "taxIncludedState": null,
                    "extendedProperties": null,
                    "taxExemptions": null,
                    "requireTax": false
                },
                "byPassSplittingRules": false,
                "resellerException": null,
                "referralCode": null,
                "marketingSource": null,
                "displayCurrency": null,
                "enableShippingRules": false,
                "upgradeOptOutReasonCode": null,
                "originalCustomerSet": null,
                "overrideCfiFlag": null,
                "customerCategory": null,
                "profileID": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                "sellingEntity": null
            },
            "orderRequest": {
                "initialOrderType": null,
                "currentRequestType": "CREATE",
                "requestID": "2ed57e3c-faa8-4f2f-a955-03f102ecb704",
                "opportunityID": null,
                "orderOperations": [
                    {
                        "receivedTime": "2023-05-04T13:21:17Z",
                        "dateModified": null,
                        "currentOwner": "Gurupadappa_Gowdar@dell.com",
                        "requestType": "CreateOrder",
                        "requestCount": 1,
                        "requestid": "2ed57e3c-faa8-4f2f-a955-03f102ecb704"
                    }
                ],
                "expiryDate": null,
                "orderNotes": null,
                "orderCreation": {
                    "dateCreated": "2023-05-04T13:21:15.033Z",
                    "creator": "Gurupadappa_Gowdar@dell.com",
                    "salesOrderDate": "2023-05-04T13:19:44Z"
                },
                "expiry": null,
                "communicationPreferences": null,
                "cfo": null,
                "linkToCancelledOrder": {
                    "dpid": null,
                    "omsNumbers": null,
                    "quoteNumber": null,
                    "quoteVersion": null
                },
                "isbulkcreatedorder": null,
                "editOrderRequests": null,
                "editOrderRequest": null,
                "cancelOrderRequest": null
            },
            "shipmentsInfo": {
                "shipment": [
                    {
                        "instructions": null,
                        "id": "0L9X4keQKEyLcx29KlsC7g",
                        "isUpgrade": false,
                        "itemIds": [
                            "v0yaZkNU7UelAqXfUmTNFA",
                            "bZfI9S1mj0-ETNiHHD4JhQ",
                            "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                            "a81e4b06-3981-47b7-a506-962476d72bca"
                        ],
                        "shipmentName": "Standard",
                        "shippingMethod": "IY",
                        "shippingOptions": [
                            "IY"
                        ],
                        "itemGroupID": null,
                        "groupName": null,
                        "groupID": null,
                        "aneSolutionName": null,
                        "agreementId": null,
                        "solutionInstanceId": null,
                        "solutionName": null,
                        "inboundShipmethod": null,
                        "deliveryCity": null,
                        "incoterms": null,
                        "shippingCarrier": null,
                        "installationInstructions": null,
                        "vatpNotes": null,
                        "shipFromGub": null,
                        "futuristicDeliveryDate": null,
                        "fgaPropertyBag": {
                            "fgaType": null,
                            "fgaConsolidationId": null,
                            "fgaConsolidationQty": "0",
                            "fgaConsolidationItemQty": "0"
                        },
                        "designatedCarrier": {
                            "preferredCarrier": null,
                            "accountNumber": null,
                            "deliveryMethod": null
                        },
                        "itemsInShipment": [
                            {
                                "shipFromState": null,
                                "siteCode": "TIL_BTO",
                                "itemId": "v0yaZkNU7UelAqXfUmTNFA",
                                "inboundShipMethod": "AR",
                                "inboundShipmentName": null,
                                "isDirectShip": false,
                                "vendorId": null
                            },
                            {
                                "shipFromState": null,
                                "siteCode": "TIL",
                                "itemId": "bZfI9S1mj0-ETNiHHD4JhQ",
                                "inboundShipMethod": "NA",
                                "inboundShipmentName": null,
                                "isDirectShip": false,
                                "vendorId": null
                            }
                        ],
                        "contactReferences": [],
                        "shipFromHub": null
                    }
                ]
            },
            "fulfillmentUnitInfo": {
                "fulfillmentUnit": [
                    {
                        "orderNumber": "740078283",
                        "amount": "2347.97",
                        "orderStatus": "BKD",
                        "dispositionCode": "CMP",
                        "orderCMPDate": null,
                        "cancelRequestInfo": null,
                        "orderTypeID": "22227",
                        "id": "3823d615-841a-4bdd-8639-bfb40567d320",
                        "shipFlag": null,
                        "orderType": "GB Order",
                        "processingPreference": {
                            "stopAtQuote": "False",
                            "frictionless": "True"
                        },
                        "itemInfo": [
                            {
                                "id": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                                "quantity": 1,
                                "labelReference": null,
                                "buildNumber": "1"
                            }
                        ],
                        "backEndMessage": "Booked",
                        "orderCreatedDate": "2023-05-04T13:23:16Z",
                        "orderStatusBackendCode": "",
                        "agreementId": "",
                        "isgAgreementId": null,
                        "shipmentId": "0L9X4keQKEyLcx29KlsC7g",
                        "xaaSOriginalOrderNumber": null,
                        "originalFulfillmentUnitId": null,
                        "editedOrderFields": null,
                        "isOrderEdited": false,
                        "isOrderEditInProgress": false,
                        "inboundShipMethod": "AR",
                        "gsoInboundShipMethod": "A",
                        "inboundShipmentName": null
                    },
                    {
                        "orderNumber": "740078284",
                        "amount": "496.48",
                        "orderStatus": "BKD",
                        "dispositionCode": "CMP",
                        "orderCMPDate": null,
                        "cancelRequestInfo": null,
                        "orderTypeID": "22227",
                        "id": "b68e9bdf-5eee-435c-a267-bef7e783ea04",
                        "shipFlag": null,
                        "orderType": "GB Order",
                        "processingPreference": {
                            "stopAtQuote": "False",
                            "frictionless": "True"
                        },
                        "itemInfo": [
                            {
                                "id": "a81e4b06-3981-47b7-a506-962476d72bca",
                                "quantity": 1,
                                "labelReference": null,
                                "buildNumber": "1"
                            }
                        ],
                        "backEndMessage": "Booked",
                        "orderCreatedDate": "2023-05-04T13:23:50Z",
                        "orderStatusBackendCode": "",
                        "agreementId": "",
                        "isgAgreementId": null,
                        "shipmentId": "0L9X4keQKEyLcx29KlsC7g",
                        "xaaSOriginalOrderNumber": null,
                        "originalFulfillmentUnitId": null,
                        "editedOrderFields": null,
                        "isOrderEdited": false,
                        "isOrderEditInProgress": false,
                        "inboundShipMethod": "NA",
                        "gsoInboundShipMethod": "G",
                        "inboundShipmentName": null
                    }
                ]
            },
            "quoteOrigin": {
                "quoteName": null,
                "quoteVersionNumber": null,
                "quoteNumber": null,
                "quoteStatus": null,
                "internalQuoteID": null,
                "equoteIDList": null,
                "legacyCartInfo": null,
                "isInvalidQuote": null
            },
            "exchangeInfo": {
                "dpsNumber": null,
                "exchangeReasonCode": null,
                "originalOrderNumber": null,
                "exchangeType": null,
                "fsrNumber": null,
                "goalLiteId": null,
                "referenceOrderDPID": null,
                "snowRequestId": null
            },
            "cfo": {
                "rel": null,
                "ref": "159756",
                "eTag": null,
                "schema": null
            },
            "customerPrivacy": {
                "shareTelephoneWithCarrier": null,
                "deliveryNoteWithPrice": null,
                "hideBillTo": null
            },
            "customerCompliance": {
                "cig": null,
                "cup": null,
                "cuu": null
            },
            "extendedProperties": {
                "CartHasFBItems": "False",
                "YellowStoneItemModel": "{\"PremiumPlusSubscription\":false,\"PremiumSubscription\":false,\"ProSupportPlusSubscription\":false,\"ProSupportSubscription\":false,\"CartHasYellowStoneItems\":false}",
                "/OrderForms/OrderForm/BillingContact/OptInFlags": "0",
                "/OrderForms/OrderForm/BillingContact/OrganizationInfo/Name": "OSTT-TEST",
                "InboundShippingOption": "",
                "maxLeadTimeItemId": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                "/TermsAndConditions": "{\"Required\":true,\"Accepted\":true}",
                "TermsAndConditionsAccepted": "True",
                "TermsAndConditionsRequired": "True",
                "Checkout-SalesOrderId": "qWqMNHjsEUOKpHvSmgugYA~002",
                "BrowserIP": "10.179.160.26",
                "AggregateAutoCollectSkus": "{\"340-CKSZ\":\"NO\"}",
                "AutoCollectSkuDetails": "[\"No AutoPilot\"]",
                "StoreTitle": "###TEST_GOP_UK_MB",
                "IsIndiaMixedCart": "False",
                "tmx_id": "ia1bb84y07r1683206389828",
                "tmx_org": "539ziukj",
                "tmx_policy": "Unified_CSB_EMEA"
            },
            "properties": {},
            "customCheckoutField": [
                {
                    "id": "vCp1jmY2Sk-wmsEncP1juA",
                    "properties": {
                        "Field_id": "6",
                        "Field_name": "ship note",
                        "Field_value": null,
                        "Field_caption": "ship note",
                        "Map_field_type": "Default",
                        "Category": "Shipping",
                        "Override_backend_field": "false",
                        "Encrypted": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                },
                {
                    "id": "_YsuYD5ryEq2Vz6IfPr2Hg",
                    "properties": {
                        "Field_id": "5",
                        "Field_name": "Billing CF",
                        "Field_value": null,
                        "Field_caption": "Billing CF",
                        "Map_field_type": "Default",
                        "Category": "Billing",
                        "Override_backend_field": "false",
                        "Encrypted": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                },
                {
                    "id": "yG2b9Iu-fEm6Fsw-97TiTQ",
                    "properties": {
                        "Field_id": "7",
                        "Field_name": "contact note",
                        "Field_value": null,
                        "Field_caption": "contact note",
                        "Map_field_type": "Default",
                        "Category": "OrderContact",
                        "Override_backend_field": "false",
                        "Encrypted": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                }
            ],
            "customCheckoutFields": [
                {
                    "id": "vCp1jmY2Sk-wmsEncP1juA",
                    "properties": {
                        "Field_name": "ship note",
                        "Field_caption": "ship note",
                        "Map_field_type": "Default",
                        "Field_value": null,
                        "Category": "Shipping",
                        "Encrypted": "false",
                        "Field_id": "6",
                        "Override_backend_field": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                },
                {
                    "id": "_YsuYD5ryEq2Vz6IfPr2Hg",
                    "properties": {
                        "Field_name": "Billing CF",
                        "Field_caption": "Billing CF",
                        "Map_field_type": "Default",
                        "Field_value": null,
                        "Category": "Billing",
                        "Encrypted": "false",
                        "Field_id": "5",
                        "Override_backend_field": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                },
                {
                    "id": "yG2b9Iu-fEm6Fsw-97TiTQ",
                    "properties": {
                        "Field_name": "contact note",
                        "Field_caption": "contact note",
                        "Map_field_type": "Default",
                        "Field_value": null,
                        "Category": "OrderContact",
                        "Encrypted": "false",
                        "Field_id": "7",
                        "Override_backend_field": "false"
                    },
                    "customcheckoutfieldName": null,
                    "customcheckoutfieldValue": null
                }
            ],
            "editedDpidFields": null,
            "frictionless": "true",
            "fuCount": 2,
            "isCpf": false,
            "connectedSetDetail": null,
            "displayOrderPath": null,
            "orderPath": null,
            "assistedSalesInformation": null,
            "scheduleInformation": null,
            "poRejectionHold": null
        },
        "summary": null
    },
    "customerDomain": {
        "resource": {
            "version": null,
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/customer/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "billCustomer": {
                "contact": {
                    "id": "93937178-9fce-4b6d-9689-8eaed52eb97a",
                    "phones": [
                        {
                            "type": "Work",
                            "countryCode": null,
                            "areaCode": "0",
                            "number": "234567898",
                            "extension": null
                        }
                    ],
                    "address": {
                        "previousId": null,
                        "id": "400000001902727",
                        "line1": "185 Farringdon Rd",
                        "line2": "",
                        "line3": "",
                        "line4": null,
                        "line5": "",
                        "city": "London",
                        "state": "LND",
                        "country": "GB",
                        "countryCode": "0",
                        "postalCode": "EC1A 1AA",
                        "status": null,
                        "isVerified": true,
                        "createdOn": null,
                        "region": "LND",
                        "domsSequenceNumber": null,
                        "other1": "London",
                        "other2": "City of London",
                        "other3": null,
                        "other4": null,
                        "other5": null,
                        "suburb": null,
                        "cityCode": null,
                        "sequenceNumber": null,
                        "addressType": null,
                        "regionName": null
                    },
                    "email": {
                        "emailId": "ostt_cp_gop_korea@uatmail.com",
                        "type": null
                    },
                    "previousCamLocationId": null,
                    "camLocationId": "400000001977980",
                    "firstName": "OSTT-Test",
                    "lastName": "TEST-CP",
                    "title": null,
                    "middleInitial": "",
                    "prefix": "",
                    "suffix": "",
                    "secondaryFirstName": null,
                    "secondaryLastName": null,
                    "secondaryNameTitle": null,
                    "secondaryNamePrefix": null,
                    "secondaryNameSuffix": null,
                    "secondaryNameMiddleInitial": null,
                    "secondaryNameMaGuid": null,
                    "secondaryNameMi": null,
                    "linkNumber": null,
                    "ucid": "",
                    "ucidStatus": null,
                    "isFunderReplaced": false,
                    "fax": null,
                    "isSupportPartner": false,
                    "additionalEmails": []
                },
                "customerNumber": "GB6400130123",
                "companyName": "OSTT-TEST",
                "companyId": null,
                "companyNumber": null,
                "previousCamId": null,
                "camId": "GB6400130123",
                "backendCustomerNumber": "GB6400130123",
                "salesChannel": null,
                "isOCICreditRequestApproved": false,
                "branchName": null,
                "departmentName": null,
                "accountId": null,
                "cpsAccountId": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                "shipmentContactId": null,
                "linkNumber": null,
                "taxIdPrimary": null,
                "taxIdSecondary": null,
                "omsCustomerId": null,
                "organizationTaxNo": null,
                "endUserId": null,
                "partnerRequestId": null,
                "partnerRequestStatus": null,
                "partyId": null,
                "properties": {
                    "IsSameAsShipping": "false",
                    "BillOptInForAddr": "N",
                    "BillOptInForPhone": "N",
                    "ContactMode": "Select",
                    "ClassCode": "GB_UKDU",
                    "CompanyNumber": "ENTP",
                    "Segment": "ENT",
                    "Type": null,
                    "Source": null,
                    "IsGstinSelected": null,
                    "GstinType": null,
                    "GstinTypeDescription": null,
                    "FR_SIRET": null,
                    "BUSINESS_TYPE": null,
                    "BUSINESS_RANGE": null,
                    "TAX_REG_NUM": null,
                    "LEITWEG_ID": null,
                    "FISCAL_CODE": null,
                    "BANK_NAME": null,
                    "BANK_ACCOUNT_NUM": null,
                    "INV_DELIVERY_METHOD": null,
                    "RECEIVER_CODE": null,
                    "IT_PEC_MAIL": null,
                    "CompanyTitle": null,
                    "CompanyStatus": null,
                    "CompanyName": null,
                    "RegionName": null,
                    "AddressInName": null
                },
                "organizationName": "OSTT-TEST",
                "organizationSecondaryName": null,
                "educationMiles": "N",
                "isEducationMilesEnrolled": false,
                "dealerId": null,
                "marketingPreferences": {
                    "PHONE": false,
                    "EMAIL": false,
                    "FAX": false,
                    "DIRECTMAIL": false
                },
                "optInFlags": null,
                "taxRegNo": "",
                "bankName": null,
                "accountNumber": null,
                "carrierType": null,
                "carrierID": null,
                "invoiceType": null,
                "accountName": "###TEST_GOP_UK_MB",
                "cpfGroupId": null,
                "invoiceDeliveryMethod": "Y",
                "language": "en",
                "receiverBusinessType": null,
                "receiverBusinessRange": null,
                "taxCategory": null,
                "taxAccountNumber": null,
                "authDealerCode": null,
                "iecCode": null,
                "accountCategory": null,
                "siretNumber": null,
                "fiscalCode": null,
                "gstINStatus": null,
                "organizationId": null,
                "organizationType": null,
                "organizationTitle": ""
            },
            "shipCustomer": {
                "contact": {
                    "id": "0L9X4keQKEyLcx29KlsC7g",
                    "phones": [
                        {
                            "type": "Work",
                            "countryCode": null,
                            "areaCode": "0",
                            "number": "234567898",
                            "extension": null
                        }
                    ],
                    "address": {
                        "previousId": null,
                        "id": "400000001902727",
                        "line1": "185 Farringdon Rd",
                        "line2": "",
                        "line3": "",
                        "line4": null,
                        "line5": "",
                        "city": "London",
                        "state": "LND",
                        "country": "GB",
                        "countryCode": "0",
                        "postalCode": "EC1A 1AA",
                        "status": null,
                        "isVerified": true,
                        "createdOn": null,
                        "region": "LND",
                        "domsSequenceNumber": null,
                        "other1": "London",
                        "other2": "City of London",
                        "other3": null,
                        "other4": null,
                        "other5": null,
                        "suburb": null,
                        "cityCode": null,
                        "sequenceNumber": null,
                        "addressType": null,
                        "regionName": null
                    },
                    "email": {
                        "emailId": "ostt_cp_gop_korea@uatmail.com",
                        "type": null
                    },
                    "previousCamLocationId": null,
                    "camLocationId": "400000001977980",
                    "firstName": "OSTT-Test",
                    "lastName": "TEST-CP",
                    "title": null,
                    "middleInitial": "",
                    "prefix": "",
                    "suffix": "",
                    "secondaryFirstName": null,
                    "secondaryLastName": null,
                    "secondaryNameTitle": null,
                    "secondaryNamePrefix": null,
                    "secondaryNameSuffix": null,
                    "secondaryNameMiddleInitial": null,
                    "secondaryNameMaGuid": null,
                    "secondaryNameMi": null,
                    "linkNumber": null,
                    "ucid": "",
                    "ucidStatus": null,
                    "isFunderReplaced": false,
                    "fax": null,
                    "isSupportPartner": false,
                    "additionalEmails": []
                },
                "customerNumber": "GB6400130123",
                "companyName": "OSTT-TEST",
                "companyId": null,
                "companyNumber": null,
                "previousCamId": null,
                "camId": "GB6400130123",
                "backendCustomerNumber": "GB6400130123",
                "salesChannel": null,
                "isOCICreditRequestApproved": false,
                "branchName": null,
                "departmentName": null,
                "accountId": null,
                "cpsAccountId": "dd542ac3-c162-4837-9e60-4a26315cfeec",
                "shipmentContactId": null,
                "linkNumber": null,
                "taxIdPrimary": null,
                "taxIdSecondary": null,
                "omsCustomerId": null,
                "organizationTaxNo": null,
                "endUserId": null,
                "partnerRequestId": null,
                "partnerRequestStatus": null,
                "partyId": null,
                "properties": {
                    "isSameAsShipping": "false",
                    "contactMode": "Select",
                    "ShipOptInAddr": "N",
                    "ShipOptInPhone": "N"
                },
                "organizationName": "OSTT-TEST",
                "organizationSecondaryName": null,
                "educationMiles": "N",
                "isEducationMilesEnrolled": false,
                "dealerId": null,
                "marketingPreferences": {
                    "PHONE": false,
                    "EMAIL": false,
                    "FAX": false,
                    "DIRECTMAIL": false
                },
                "optInFlags": null,
                "taxRegNo": null,
                "bankName": null,
                "accountNumber": null,
                "carrierType": null,
                "carrierID": null,
                "invoiceType": null,
                "accountName": "###TEST_GOP_UK_MB",
                "cpfGroupId": null,
                "invoiceDeliveryMethod": "Y",
                "language": "en",
                "receiverBusinessType": null,
                "receiverBusinessRange": null,
                "taxCategory": null,
                "taxAccountNumber": null,
                "authDealerCode": null,
                "iecCode": null,
                "accountCategory": null,
                "siretNumber": null,
                "fiscalCode": null,
                "gstINStatus": null,
                "organizationId": null,
                "organizationType": null,
                "organizationTitle": ""
            },
            "shipmentCustomers": [
                {
                    "contact": {
                        "id": "0L9X4keQKEyLcx29KlsC7g",
                        "phones": [
                            {
                                "type": "Work",
                                "countryCode": null,
                                "areaCode": "0",
                                "number": "234567898",
                                "extension": null
                            }
                        ],
                        "address": {
                            "previousId": null,
                            "id": "400000001902727",
                            "line1": "185 Farringdon Rd",
                            "line2": "",
                            "line3": "",
                            "line4": null,
                            "line5": "",
                            "city": "London",
                            "state": "LND",
                            "country": "GB",
                            "countryCode": "0",
                            "postalCode": "EC1A 1AA",
                            "status": null,
                            "isVerified": true,
                            "createdOn": null,
                            "region": "LND",
                            "domsSequenceNumber": null,
                            "other1": "London",
                            "other2": "City of London",
                            "other3": null,
                            "other4": null,
                            "other5": null,
                            "suburb": null,
                            "cityCode": null,
                            "sequenceNumber": null,
                            "addressType": null,
                            "regionName": null
                        },
                        "email": {
                            "emailId": "ostt_cp_gop_korea@uatmail.com",
                            "type": null
                        },
                        "previousCamLocationId": null,
                        "camLocationId": "400000001977980",
                        "firstName": "OSTT-Test",
                        "lastName": "TEST-CP",
                        "title": null,
                        "middleInitial": "",
                        "prefix": "",
                        "suffix": "",
                        "secondaryFirstName": null,
                        "secondaryLastName": null,
                        "secondaryNameTitle": null,
                        "secondaryNamePrefix": null,
                        "secondaryNameSuffix": null,
                        "secondaryNameMiddleInitial": null,
                        "secondaryNameMaGuid": null,
                        "secondaryNameMi": null,
                        "linkNumber": null,
                        "ucid": "",
                        "ucidStatus": null,
                        "isFunderReplaced": false,
                        "fax": null,
                        "isSupportPartner": false,
                        "additionalEmails": []
                    },
                    "customerNumber": "GB6400130123",
                    "companyName": "OSTT-TEST",
                    "companyId": null,
                    "companyNumber": null,
                    "previousCamId": null,
                    "camId": "GB6400130123",
                    "backendCustomerNumber": "GB6400130123",
                    "salesChannel": null,
                    "isOCICreditRequestApproved": false,
                    "branchName": null,
                    "departmentName": null,
                    "accountId": null,
                    "cpsAccountId": null,
                    "shipmentContactId": null,
                    "linkNumber": null,
                    "taxIdPrimary": null,
                    "taxIdSecondary": null,
                    "omsCustomerId": null,
                    "organizationTaxNo": null,
                    "endUserId": null,
                    "partnerRequestId": null,
                    "partnerRequestStatus": null,
                    "partyId": null,
                    "properties": {
                        "isSameAsShipping": "false",
                        "contactMode": "Select",
                        "ShipOptInAddr": "N",
                        "ShipOptInPhone": "N"
                    },
                    "organizationName": "OSTT-TEST",
                    "organizationSecondaryName": null,
                    "educationMiles": "N",
                    "isEducationMilesEnrolled": false,
                    "dealerId": null,
                    "marketingPreferences": {
                        "PHONE": false,
                        "EMAIL": false,
                        "FAX": false,
                        "DIRECTMAIL": false
                    },
                    "optInFlags": null,
                    "taxRegNo": null,
                    "bankName": null,
                    "accountNumber": null,
                    "carrierType": null,
                    "carrierID": null,
                    "invoiceType": null,
                    "accountName": null,
                    "cpfGroupId": null,
                    "invoiceDeliveryMethod": "Y",
                    "language": "en",
                    "receiverBusinessType": null,
                    "receiverBusinessRange": null,
                    "taxCategory": null,
                    "taxAccountNumber": null,
                    "authDealerCode": null,
                    "iecCode": null,
                    "accountCategory": null,
                    "siretNumber": null,
                    "fiscalCode": null,
                    "gstINStatus": null,
                    "organizationId": null,
                    "organizationType": null,
                    "organizationTitle": ""
                }
            ],
            "resellerCustomer": null,
            "soldToCustomer": {
                "contact": {
                    "id": "AStrlqoihkmVyJ00qmTrQw",
                    "phones": [
                        {
                            "type": "Work",
                            "countryCode": null,
                            "areaCode": "0",
                            "number": "234567898",
                            "extension": null
                        }
                    ],
                    "address": {
                        "previousId": null,
                        "id": "400000001902727",
                        "line1": "185 Farringdon Rd",
                        "line2": null,
                        "line3": null,
                        "line4": null,
                        "line5": null,
                        "city": "London",
                        "state": "LND",
                        "country": "GB",
                        "countryCode": null,
                        "postalCode": "EC1A 1AA",
                        "status": null,
                        "isVerified": false,
                        "createdOn": null,
                        "region": "LND",
                        "domsSequenceNumber": null,
                        "other1": "London",
                        "other2": "City of London",
                        "other3": null,
                        "other4": null,
                        "other5": null,
                        "suburb": null,
                        "cityCode": null,
                        "sequenceNumber": null,
                        "addressType": null,
                        "regionName": null
                    },
                    "email": {
                        "emailId": "ostt_cp_gop_korea@uatmail.com",
                        "type": null
                    },
                    "previousCamLocationId": null,
                    "camLocationId": "400000001977980",
                    "firstName": "OSTT-Test",
                    "lastName": "TEST-CP",
                    "title": null,
                    "middleInitial": null,
                    "prefix": null,
                    "suffix": null,
                    "secondaryFirstName": null,
                    "secondaryLastName": null,
                    "secondaryNameTitle": null,
                    "secondaryNamePrefix": null,
                    "secondaryNameSuffix": null,
                    "secondaryNameMiddleInitial": null,
                    "secondaryNameMaGuid": null,
                    "secondaryNameMi": null,
                    "linkNumber": null,
                    "ucid": null,
                    "ucidStatus": null,
                    "isFunderReplaced": false,
                    "fax": null,
                    "isSupportPartner": false,
                    "additionalEmails": []
                },
                "customerNumber": "GB6400130123",
                "companyName": "OSTT-TEST",
                "companyId": null,
                "companyNumber": null,
                "previousCamId": null,
                "camId": "GB6400130123",
                "backendCustomerNumber": "GB6400130123",
                "salesChannel": null,
                "isOCICreditRequestApproved": false,
                "branchName": null,
                "departmentName": null,
                "accountId": null,
                "cpsAccountId": null,
                "shipmentContactId": null,
                "linkNumber": null,
                "taxIdPrimary": null,
                "taxIdSecondary": null,
                "omsCustomerId": null,
                "organizationTaxNo": null,
                "endUserId": null,
                "partnerRequestId": null,
                "partnerRequestStatus": null,
                "partyId": null,
                "properties": {
                    "SnapShotOrderContact": "{\"contact\":{\"id\":\"oZ5k-eEA1EyNW4BezVBmcg\",\"phones\":[{\"type\":\"Work\",\"countryCode\":null,\"areaCode\":null,\"number\":\"5123232323\",\"extension\":null}],\"address\":{\"previousId\":null,\"id\":null,\"line1\":null,\"line2\":null,\"line3\":null,\"line4\":null,\"line5\":null,\"city\":null,\"state\":null,\"country\":null,\"countryCode\":null,\"postalCode\":null,\"status\":null,\"isVerified\":false,\"createdOn\":null,\"region\":null,\"domsSequenceNumber\":null,\"other1\":null,\"other2\":null,\"other3\":null,\"other4\":null,\"other5\":null,\"suburb\":null,\"cityCode\":null,\"sequenceNumber\":null,\"addressType\":null,\"regionName\":null},\"email\":{\"emailId\":\"Gurupadappa_Gowdar@dell.com\",\"type\":null},\"previousCamLocationId\":null,\"camLocationId\":null,\"firstName\":\"Gurupadappa\",\"lastName\":\"Gowdar\",\"title\":null,\"middleInitial\":null,\"prefix\":null,\"suffix\":null,\"secondaryFirstName\":null,\"secondaryLastName\":null,\"secondaryNameTitle\":null,\"secondaryNamePrefix\":null,\"secondaryNameSuffix\":null,\"secondaryNameMiddleInitial\":null,\"secondaryNameMaGuid\":null,\"secondaryNameMi\":null,\"linkNumber\":null,\"ucid\":null,\"ucidStatus\":null,\"isFunderReplaced\":false,\"fax\":null,\"isSupportPartner\":false,\"additionalEmails\":[]},\"customerNumber\":null,\"companyName\":\"Dell\",\"companyId\":null,\"companyNumber\":null,\"previousCamId\":null,\"camId\":null,\"backendCustomerNumber\":null,\"salesChannnel\":null,\"isOciCreditRequestApproved\":false,\"branchName\":null,\"departmentName\":null,\"accountId\":null,\"cpsAccountId\":null,\"shipmentContactId\":null,\"linkNumber\":null,\"taxIdPrimary\":null,\"taxIdSecondary\":null,\"omsCustomerId\":null,\"organizationTaxNo\":null,\"endUserId\":null,\"partnerRequestId\":null,\"partnerRequestStatus\":null,\"partyId\":null,\"properties\":null,\"organizationName\":\"Dell\",\"organizationSecondaryName\":null,\"educationMiles\":null,\"isEducationMilesEnrolled\":false,\"dealerId\":null,\"marketingPreferences\":null,\"optInFlags\":null,\"taxRegNo\":\"\",\"bankName\":\"\",\"accountNumber\":\"\",\"carrierType\":\"\",\"carrierID\":\"\",\"invoiceType\":\"\",\"accountName\":null,\"cpfGroupId\":null,\"invoiceDeliveryMethod\":\"Y\",\"language\":\"en\",\"receiverBusinessType\":null,\"receiverBusinessRange\":null,\"taxCategory\":null,\"taxAccountNumber\":null,\"authDealerCode\":null,\"iecCode\":null,\"accountCategory\":null,\"siretNumber\":null,\"fiscalCode\":null,\"gstINStatus\":null,\"organizationId\":null,\"organizationType\":null,\"organizationTitle\":null}"
                },
                "organizationName": "OSTT-TEST",
                "organizationSecondaryName": null,
                "educationMiles": null,
                "isEducationMilesEnrolled": false,
                "dealerId": null,
                "marketingPreferences": null,
                "optInFlags": null,
                "taxRegNo": "",
                "bankName": "",
                "accountNumber": "",
                "carrierType": "",
                "carrierID": "",
                "invoiceType": "",
                "accountName": null,
                "cpfGroupId": null,
                "invoiceDeliveryMethod": "Y",
                "language": "en",
                "receiverBusinessType": null,
                "receiverBusinessRange": null,
                "taxCategory": null,
                "taxAccountNumber": null,
                "authDealerCode": null,
                "iecCode": null,
                "accountCategory": null,
                "siretNumber": null,
                "fiscalCode": null,
                "gstINStatus": null,
                "organizationId": null,
                "organizationType": null,
                "organizationTitle": ""
            },
            "deliveryToCustomers": [],
            "dfEndUserCustomer": null,
            "dfPartnerCustomer": null,
            "endUserCustomer": {
                "contact": {
                    "id": "1-fYT_H6dEmJN1t5BOy14A",
                    "phones": [
                        {
                            "type": "Work",
                            "countryCode": null,
                            "areaCode": "0",
                            "number": "234567898",
                            "extension": null
                        }
                    ],
                    "address": {
                        "previousId": null,
                        "id": "400000001902727",
                        "line1": "185 Farringdon Rd",
                        "line2": "",
                        "line3": "",
                        "line4": null,
                        "line5": null,
                        "city": "London",
                        "state": "LND",
                        "country": "GB",
                        "countryCode": null,
                        "postalCode": "EC1A 1AA",
                        "status": null,
                        "isVerified": false,
                        "createdOn": null,
                        "region": "LND",
                        "domsSequenceNumber": null,
                        "other1": null,
                        "other2": null,
                        "other3": null,
                        "other4": null,
                        "other5": null,
                        "suburb": null,
                        "cityCode": null,
                        "sequenceNumber": null,
                        "addressType": "EndUser",
                        "regionName": null
                    },
                    "email": {
                        "emailId": "ostt_cp_gop_korea@uatmail.com",
                        "type": null
                    },
                    "previousCamLocationId": null,
                    "camLocationId": "400000001977980",
                    "firstName": "OSTT-Test",
                    "lastName": "TEST-CP",
                    "title": null,
                    "middleInitial": null,
                    "prefix": null,
                    "suffix": null,
                    "secondaryFirstName": null,
                    "secondaryLastName": null,
                    "secondaryNameTitle": null,
                    "secondaryNamePrefix": null,
                    "secondaryNameSuffix": null,
                    "secondaryNameMiddleInitial": null,
                    "secondaryNameMaGuid": null,
                    "secondaryNameMi": null,
                    "linkNumber": null,
                    "ucid": null,
                    "ucidStatus": null,
                    "isFunderReplaced": false,
                    "fax": null,
                    "isSupportPartner": false,
                    "additionalEmails": []
                },
                "customerNumber": "GB6400130123",
                "companyName": "OSTT-TEST",
                "companyId": null,
                "companyNumber": null,
                "previousCamId": null,
                "camId": "GB6400130123",
                "backendCustomerNumber": null,
                "salesChannel": null,
                "isOCICreditRequestApproved": false,
                "branchName": null,
                "departmentName": null,
                "accountId": null,
                "cpsAccountId": null,
                "shipmentContactId": null,
                "linkNumber": null,
                "taxIdPrimary": null,
                "taxIdSecondary": null,
                "omsCustomerId": null,
                "organizationTaxNo": null,
                "endUserId": null,
                "partnerRequestId": null,
                "partnerRequestStatus": null,
                "partyId": null,
                "properties": null,
                "organizationName": "OSTT-TEST",
                "organizationSecondaryName": null,
                "educationMiles": null,
                "isEducationMilesEnrolled": false,
                "dealerId": null,
                "marketingPreferences": null,
                "optInFlags": null,
                "taxRegNo": "",
                "bankName": "",
                "accountNumber": "",
                "carrierType": "",
                "carrierID": "",
                "invoiceType": "",
                "accountName": null,
                "cpfGroupId": null,
                "invoiceDeliveryMethod": "Y",
                "language": "en",
                "receiverBusinessType": null,
                "receiverBusinessRange": null,
                "taxCategory": null,
                "taxAccountNumber": null,
                "authDealerCode": null,
                "iecCode": null,
                "accountCategory": null,
                "siretNumber": null,
                "fiscalCode": null,
                "gstINStatus": null,
                "organizationId": null,
                "organizationType": null,
                "organizationTitle": ""
            },
            "installAtCustomers": [],
            "mailAtCustomer": null,
            "n1Partner": null,
            "orderContact": {
                "contact": {
                    "id": "oZ5k-eEA1EyNW4BezVBmcg",
                    "phones": [
                        {
                            "type": "Work",
                            "countryCode": null,
                            "areaCode": null,
                            "number": "5123232323",
                            "extension": null
                        }
                    ],
                    "address": {
                        "previousId": null,
                        "id": null,
                        "line1": null,
                        "line2": null,
                        "line3": null,
                        "line4": null,
                        "line5": null,
                        "city": null,
                        "state": null,
                        "country": null,
                        "countryCode": null,
                        "postalCode": null,
                        "status": null,
                        "isVerified": false,
                        "createdOn": null,
                        "region": null,
                        "domsSequenceNumber": null,
                        "other1": null,
                        "other2": null,
                        "other3": null,
                        "other4": null,
                        "other5": null,
                        "suburb": null,
                        "cityCode": null,
                        "sequenceNumber": null,
                        "addressType": null,
                        "regionName": null
                    },
                    "email": {
                        "emailId": "Gurupadappa_Gowdar@dell.com",
                        "type": null
                    },
                    "previousCamLocationId": null,
                    "camLocationId": null,
                    "firstName": "Gurupadappa",
                    "lastName": "Gowdar",
                    "title": null,
                    "middleInitial": null,
                    "prefix": null,
                    "suffix": null,
                    "secondaryFirstName": null,
                    "secondaryLastName": null,
                    "secondaryNameTitle": null,
                    "secondaryNamePrefix": null,
                    "secondaryNameSuffix": null,
                    "secondaryNameMiddleInitial": null,
                    "secondaryNameMaGuid": null,
                    "secondaryNameMi": null,
                    "linkNumber": null,
                    "ucid": null,
                    "ucidStatus": null,
                    "isFunderReplaced": false,
                    "fax": null,
                    "isSupportPartner": false,
                    "additionalEmails": []
                },
                "customerNumber": null,
                "companyName": "Dell",
                "companyId": null,
                "companyNumber": null,
                "previousCamId": null,
                "camId": null,
                "backendCustomerNumber": null,
                "salesChannel": null,
                "isOCICreditRequestApproved": false,
                "branchName": null,
                "departmentName": null,
                "accountId": null,
                "cpsAccountId": null,
                "shipmentContactId": null,
                "linkNumber": null,
                "taxIdPrimary": null,
                "taxIdSecondary": null,
                "omsCustomerId": null,
                "organizationTaxNo": null,
                "endUserId": null,
                "partnerRequestId": null,
                "partnerRequestStatus": null,
                "partyId": null,
                "properties": null,
                "organizationName": "Dell",
                "organizationSecondaryName": null,
                "educationMiles": null,
                "isEducationMilesEnrolled": false,
                "dealerId": null,
                "marketingPreferences": null,
                "optInFlags": null,
                "taxRegNo": "",
                "bankName": "",
                "accountNumber": "",
                "carrierType": "",
                "carrierID": "",
                "invoiceType": "",
                "accountName": null,
                "cpfGroupId": null,
                "invoiceDeliveryMethod": "Y",
                "language": "en",
                "receiverBusinessType": null,
                "receiverBusinessRange": null,
                "taxCategory": null,
                "taxAccountNumber": null,
                "authDealerCode": null,
                "iecCode": null,
                "accountCategory": null,
                "siretNumber": null,
                "fiscalCode": null,
                "gstINStatus": null,
                "organizationId": null,
                "organizationType": null,
                "organizationTitle": null
            },
            "funderCustomer": null
        },
        "summary": null
    },
    "paymentDomain": {
        "resource": {
            "version": null,
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/payment/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "payments": [
                {
                    "accountEmail": null,
                    "amount": 2844.45,
                    "bankName": null,
                    "billingCadenceType": "",
                    "billPlanId": null,
                    "cardType": null,
                    "globalPaymentId": "6DA05D71-77FE-418D-B8CA-D6B52C0A9752",
                    "id": "f02422d1-04d2-454f-acfe-3d1b416aaaec",
                    "isCcVerified": null,
                    "isLease": false,
                    "isManual": null,
                    "isPrepaid": true,
                    "isRecurringPayment": false,
                    "originalOrderNumber": null,
                    "payeeAmount": 0,
                    "payerName": null,
                    "paymentDescription": "WireTransfer",
                    "paymentImpacts": [
                        {
                            "authApproved": false,
                            "authDate": "0001-01-01T00:00:00Z",
                            "authExactMessage": null,
                            "authNumber": null,
                            "authorizationCode": null,
                            "authorizationStatus": null,
                            "authorizedAmount": 2347.97,
                            "cancelledOrderForAuthId": null,
                            "globalPaymentId": "6DA05D71-77FE-418D-B8CA-D6B52C0A9752",
                            "fulfillmentUnitId": "3823d615-841a-4bdd-8639-bfb40567d320",
                            "authBankMessage": false
                        },
                        {
                            "authApproved": false,
                            "authDate": "0001-01-01T00:00:00Z",
                            "authExactMessage": null,
                            "authNumber": null,
                            "authorizationCode": null,
                            "authorizationStatus": null,
                            "authorizedAmount": 496.48,
                            "cancelledOrderForAuthId": null,
                            "globalPaymentId": "6DA05D71-77FE-418D-B8CA-D6B52C0A9752",
                            "fulfillmentUnitId": "b68e9bdf-5eee-435c-a267-bef7e783ea04",
                            "authBankMessage": false
                        }
                    ],
                    "paymentReceiptNumber": null,
                    "paymentType": "WT",
                    "purchaseOrderNumber": null,
                    "referenceNumber": "Test321",
                    "serviceType": null,
                    "subscriptionServiceType": [],
                    "term": "Prepaid",
                    "transferDate": null,
                    "jaccsId": null,
                    "isInterestApplied": false,
                    "emiAmountExcludingInstallmentCharges": 0,
                    "emiAmountPerInstallment": 0,
                    "emiNumberOfInstallments": 0
                }
            ]
        },
        "summary": null
    },
    "productDomain": {
        "resource": {
            "type": null,
            "obLiteItemsUri": null,
            "processedUri": null,
            "version": null,
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/product/7040000330593"
        },
        "summary": null,
        "data": {
            "items": [
                {
                    "id": "v0yaZkNU7UelAqXfUmTNFA",
                    "openBasketItemId": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "openBasketLiteUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/ItemOrderlite/7040000330593/1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "openBasketCompleteItemUrl": null,
                    "osemItemExtensionUri": null,
                    "configRequestUrl": null,
                    "configuredSelectionsUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/item/configuredselections/7040000330593/1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "txProductUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/item/transactproduct/7040000330593/1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "txMiscellaneousUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/item/transactmiscellaneous/7040000330593/1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "txRelationship": null,
                    "txShopPriceUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/item/transactshopprice/7040000330593/1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "parentItemId": "00000000-0000-0000-0000-000000000000",
                    "itemType": "OrderCode_V4",
                    "catalogId": 0,
                    "quantity": 1,
                    "upgrade": null,
                    "stockReservationId": null,
                    "poLineNumber": null,
                    "extendedProperties": {},
                    "itemExtendedProperties": [
                        {
                            "key": "ItemSource",
                            "namespace": "converged-cart",
                            "value": "Shop"
                        },
                        {
                            "key": "converged_cart_item_key",
                            "namespace": "converged-cart",
                            "value": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb"
                        }
                    ],
                    "metadata": null,
                    "isParentAsset": false,
                    "targetAssetId": null,
                    "targetAssetType": null,
                    "labelReference": null,
                    "contract": null,
                    "goalId": null,
                    "opportunityLineId": null,
                    "skus": [
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Dell Latitude 5420 XCTO Base",
                            "itemTypeCode": "2",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Base",
                            "parentModuleId": "1",
                            "parentOptionId": "G4GVSTR",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 1,
                            "skuNumber": "210-AYNM",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "11th Generation Intel vPro with Intel Core i5-1145G7 (4 Core, 8 MB Cache, up to 4.4GHz)",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Processor",
                            "parentModuleId": "146",
                            "parentOptionId": "GG5S8B4",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 2,
                            "skuNumber": "379-BEHF",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Windows 11 Pro, English, Dutch, French, German, Italian",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Operating System",
                            "parentModuleId": "11",
                            "parentOptionId": "G0WJAGQ",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 3,
                            "skuNumber": "619-APWY",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No AutoPilot",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Windows AutoPilot",
                            "parentModuleId": "291",
                            "parentOptionId": "GYEO2AP",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 4,
                            "skuNumber": "340-CKSZ",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Microsoft Office 30 Day Trial - Excludes Office License",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Microsoft Application Software",
                            "parentModuleId": "1002",
                            "parentOptionId": "GHKU96A",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 5,
                            "skuNumber": "630-ABBT",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No Anti-Virus Software",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Protect your new PC",
                            "parentModuleId": "1014",
                            "parentOptionId": "GD4K19S",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 6,
                            "skuNumber": "650-AAAM",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "I5-1145G7 Vpro, Intel Iris Xe Graphics Capable, Thunderbolt",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Base Options",
                            "parentModuleId": "149",
                            "parentOptionId": "G9YX6CO",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 7,
                            "skuNumber": "338-BXRV",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "VMWCB Endpoint Stnd NGAV B-EDR w/ProSupport 1yr",
                            "itemTypeCode": "Y",
                            "lineOfBusiness": "NS",
                            "moduleDescription": "Dell Endpoint Security",
                            "parentModuleId": "156",
                            "parentOptionId": "G4B3QJR",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 8,
                            "skuNumber": "528-CHEC",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Dell Applications for Windows 11",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Non-Microsoft Application Software",
                            "parentModuleId": "1003",
                            "parentOptionId": "GNEOGF7",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 9,
                            "skuNumber": "658-BFHI",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "16 GB, 2 x 8 GB, DDR4, 3200 MT/s, dual-channel, Non-ECC",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Memory",
                            "parentModuleId": "3",
                            "parentOptionId": "G4TUP9C",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 10,
                            "skuNumber": "370-AFVQ",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "M.2 512GB PCIe NVMe Class 40 Solid State Drive",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Hard Drive",
                            "parentModuleId": "8",
                            "parentOptionId": "GUW8TOR",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 11,
                            "skuNumber": "400-BNHR",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Intel vPro Active Management Technology (for vPro CPU, vPro Capable)",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Systems Management",
                            "parentModuleId": "49",
                            "parentOptionId": "G8IU4L2",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 12,
                            "skuNumber": "631-ACTO",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Intel Wi-Fi 6 AX201 2x2 .11ax 160MHz + Bluetooth 5.2",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Wireless",
                            "parentModuleId": "19",
                            "parentOptionId": "GQWT6XF",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 13,
                            "skuNumber": "555-BGGT",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Wireless Intel AX201 WLAN Driver MOD-SRV",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Driver",
                            "parentModuleId": "7",
                            "parentOptionId": "G02IWEL",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 14,
                            "skuNumber": "555-BGIQ",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "14\" FHD (1920x1080) Non-Touch, Anti-Glare, 250nits",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "LCD",
                            "parentModuleId": "760",
                            "parentOptionId": "G6VDBCY",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 15,
                            "skuNumber": "391-BFPR",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "LCD back cover for Latitude 5420 WLAN/WWAN",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "LCD",
                            "parentModuleId": "760",
                            "parentOptionId": "G6VDBCY",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 16,
                            "skuNumber": "320-BECK",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "HD Camera Bezel with Mic",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "LCD",
                            "parentModuleId": "760",
                            "parentOptionId": "G6VDBCY",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 17,
                            "skuNumber": "325-BDYX",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "11th Gen Intel Core i5 vPro label",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Processor Branding",
                            "parentModuleId": "749",
                            "parentOptionId": "GK432YS",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 18,
                            "skuNumber": "340-CTSV",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No Mobile Broadband Card",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Mobile Broadband",
                            "parentModuleId": "114",
                            "parentOptionId": "GR957IY",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 19,
                            "skuNumber": "556-BBCD",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Single Point keyboard English UK with backlit",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Keyboard",
                            "parentModuleId": "4",
                            "parentOptionId": "GN1V8BG",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 20,
                            "skuNumber": "583-BHFS",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Palmrest, NFC, Fingerprint Reader, Contacted & Contactless SmartCard Reader, Thunderbolt 4",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "PalmRest",
                            "parentModuleId": "55",
                            "parentOptionId": "G4SX7ET",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 21,
                            "skuNumber": "346-BGVL",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "65W Type-C EPEAT Adapter",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "AC Adapter",
                            "parentModuleId": "1015",
                            "parentOptionId": "G35S0FA",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 22,
                            "skuNumber": "492-BCXP",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "E4 Power Cord 1M for English-UK",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Cable",
                            "parentModuleId": "20",
                            "parentOptionId": "GNQGW0U",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 23,
                            "skuNumber": "470-AEOR",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "4 Cell 63Whr ExpressChargeTM Capable Battery",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Primary Battery",
                            "parentModuleId": "112",
                            "parentOptionId": "G3UJTGN",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 24,
                            "skuNumber": "451-BCSW",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No Media",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Operating System Recovery Options",
                            "parentModuleId": "200013",
                            "parentOptionId": "GBZV8U6",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 25,
                            "skuNumber": "620-AAOH",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "English, French, German, Italian, Dutch Shipping Docs",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Documentation/Disks",
                            "parentModuleId": "21",
                            "parentOptionId": "GDM6EJN",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 26,
                            "skuNumber": "340-AULI",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Quick start guide for Windows 10, Ubuntu",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Placemat",
                            "parentModuleId": "60",
                            "parentOptionId": "G87Z3CW",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 27,
                            "skuNumber": "340-CUNW",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No Resource USB Media",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Resource DVD",
                            "parentModuleId": "50",
                            "parentOptionId": "G5KFAU6",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 28,
                            "skuNumber": "430-XXYG",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "ENERGY STAR Qualified",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "E-Star",
                            "parentModuleId": "122",
                            "parentOptionId": "GFSJ2Q8",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 29,
                            "skuNumber": "387-BBPC",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Not selected in this configuration",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Label",
                            "parentModuleId": "676",
                            "parentOptionId": "GZK1PNU",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 30,
                            "skuNumber": "817-BBBC",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No EAN Shipping Box Label",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Support Tech Sheet and Powercord",
                            "parentModuleId": "292",
                            "parentOptionId": "GOK9M4D",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 31,
                            "skuNumber": "817-BBBS",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Min Config 65W Adapter + TGL CPU",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Packaging",
                            "parentModuleId": "465",
                            "parentOptionId": "GXBNOQ3",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 32,
                            "skuNumber": "340-CUOW",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Dell Order",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "Order Information",
                            "parentModuleId": "111",
                            "parentOptionId": "GKCQZ43",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 33,
                            "skuNumber": "799-AANV",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "BTO Standard Shipment (VS)",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Transportation from ODM to region",
                            "parentModuleId": "200080",
                            "parentOptionId": "G1IR983",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 34,
                            "skuNumber": "800-BBQK",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Latitude 5420 Bottom Door",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Chassis Options",
                            "parentModuleId": "116",
                            "parentOptionId": "GGAFH9P",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 35,
                            "skuNumber": "321-BGBE",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Custom BTO Configuration",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "99",
                            "moduleDescription": "FGA Module",
                            "parentModuleId": "572",
                            "parentOptionId": "CTOFGA",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 36,
                            "skuNumber": "817-BBCE",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "1Y Collect and Return Service",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Service",
                            "parentModuleId": "29",
                            "parentOptionId": "G7ZNWH8",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 37,
                            "skuNumber": "709-16266",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "1Y ProSupport and Next Business Day Onsite Service Upgrade",
                            "itemTypeCode": "8",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Extended Service",
                            "parentModuleId": "30",
                            "parentOptionId": "GC9L54K",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 38,
                            "skuNumber": "865-72487",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Y2-3 ProSupport and Next Business Day Onsite Service Extension",
                            "itemTypeCode": "8",
                            "lineOfBusiness": "50",
                            "moduleDescription": "Extended Service",
                            "parentModuleId": "30",
                            "parentOptionId": "GC9L54K",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 39,
                            "skuNumber": "865-72489",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "EPEAT 2018 Registered (Gold)",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "99",
                            "moduleDescription": "EPEAT 2018",
                            "parentModuleId": "200331",
                            "parentOptionId": "GBU8CHM",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 40,
                            "skuNumber": "379-BDZB",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": "",
                            "description": "Configuration Services - Custom Ship Box Label",
                            "itemTypeCode": "6",
                            "lineOfBusiness": null,
                            "moduleDescription": "Required",
                            "parentModuleId": "650",
                            "parentOptionId": "1052211",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 41,
                            "skuNumber": "691-15423",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": "",
                            "description": "Configuration Services - Custom, Asset Tag - System",
                            "itemTypeCode": "6",
                            "lineOfBusiness": null,
                            "moduleDescription": "Required",
                            "parentModuleId": "650",
                            "parentOptionId": "1066772",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 42,
                            "skuNumber": "691-15421",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": "",
                            "description": "INFO,REPORTING",
                            "itemTypeCode": "6",
                            "lineOfBusiness": null,
                            "moduleDescription": "Required Alternative",
                            "parentModuleId": "200675",
                            "parentOptionId": "1052155",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 43,
                            "skuNumber": "494-23503",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": "",
                            "description": "Configuration Services - Custom, Image Load",
                            "itemTypeCode": "6",
                            "lineOfBusiness": null,
                            "moduleDescription": "Optional Alternative",
                            "parentModuleId": "200625",
                            "parentOptionId": "1052156",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 44,
                            "skuNumber": "691-14865",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": "",
                            "description": "SI,MOD,INFO,TRACKPO,NUMBER,30",
                            "itemTypeCode": "6",
                            "lineOfBusiness": null,
                            "moduleDescription": "Optional",
                            "parentModuleId": "651",
                            "parentOptionId": "1052154",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 45,
                            "skuNumber": "494-34882",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        }
                    ],
                    "customerSpecificFields": null,
                    "serviceTags": [],
                    "associatedItems": [],
                    "baseSkuNumber": "210-AYNM",
                    "description": "Test0501IFC",
                    "orderCode": "rcrc1506172-6210948",
                    "siNumber": "BHR101",
                    "itemVersion": "V4",
                    "categories": [
                        {
                            "name": "CONFIG",
                            "id": "root",
                            "description": "CONFIG"
                        },
                        {
                            "name": "ProductLine",
                            "id": "p2",
                            "description": "Laptops"
                        },
                        {
                            "name": "Brand",
                            "id": "b3",
                            "description": "Dell Latitude"
                        },
                        {
                            "name": "Family",
                            "id": "f15356",
                            "description": "South Peak 14 (5420)"
                        }
                    ],
                    "baseSkuClass": ">/115",
                    "baseSkuClassDescription": "Dell Latitude 5420 XCTO Base",
                    "externalName": "Test0501IFC",
                    "cficomments": [
                        {
                            "id": null,
                            "comment": " Test9",
                            "code": null,
                            "type": null,
                            "isRequired": "False"
                        },
                        {
                            "id": null,
                            "comment": " Test8",
                            "code": null,
                            "type": null,
                            "isRequired": "False"
                        }
                    ],
                    "goalLineId": null,
                    "assets": [],
                    "chassisId": 38690,
                    "productLineId": 2,
                    "isTied": false,
                    "shipsWith": false,
                    "tieNum": null,
                    "rsMultiQuantity": null,
                    "rsParentItemId": null,
                    "isCPScore": false,
                    "callbacks": null
                },
                {
                    "id": "bZfI9S1mj0-ETNiHHD4JhQ",
                    "openBasketItemId": "a81e4b06-3981-47b7-a506-962476d72bca",
                    "openBasketLiteUrl": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/Product/ItemOrderlite/7040000330593/a81e4b06-3981-47b7-a506-962476d72bca",
                    "openBasketCompleteItemUrl": null,
                    "osemItemExtensionUri": null,
                    "configRequestUrl": null,
                    "configuredSelectionsUrl": null,
                    "txProductUrl": null,
                    "txMiscellaneousUrl": null,
                    "txRelationship": null,
                    "txShopPriceUrl": null,
                    "parentItemId": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "itemType": "OrderCode_V4",
                    "catalogId": 0,
                    "quantity": 1,
                    "upgrade": null,
                    "stockReservationId": "",
                    "poLineNumber": null,
                    "extendedProperties": {},
                    "itemExtendedProperties": [
                        {
                            "key": "ItemSource",
                            "namespace": "converged-cart",
                            "value": "Shop"
                        },
                        {
                            "key": "converged_cart_item_key",
                            "namespace": "converged-cart",
                            "value": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb"
                        }
                    ],
                    "metadata": null,
                    "isParentAsset": false,
                    "targetAssetId": null,
                    "targetAssetType": null,
                    "labelReference": null,
                    "contract": null,
                    "goalId": null,
                    "opportunityLineId": null,
                    "skus": [
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Power Cord - C5, UK",
                            "itemTypeCode": "3",
                            "lineOfBusiness": "90",
                            "moduleDescription": "Powercord",
                            "parentModuleId": "207",
                            "parentOptionId": "GDAFN27",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 1,
                            "skuNumber": "450-AICE",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "SnP order - EMEA.",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "NS",
                            "moduleDescription": "Order Information",
                            "parentModuleId": "111",
                            "parentOptionId": "G3MI1LT",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 2,
                            "skuNumber": "800-10243",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "Dell Thunderbolt Dock WD22TB4, 180W",
                            "itemTypeCode": "2",
                            "lineOfBusiness": "DP",
                            "moduleDescription": "Base",
                            "parentModuleId": "1",
                            "parentOptionId": "GCXW270",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 3,
                            "skuNumber": "210-BDTD",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "3Y Basic with Advanced Exchange - Minimum Warranty",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "90",
                            "moduleDescription": "Dell Services:Hardware Support",
                            "parentModuleId": "29",
                            "parentOptionId": "G1ORWX6",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 4,
                            "skuNumber": "709-18970",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        },
                        {
                            "class": null,
                            "discountClass": null,
                            "description": "No Warranty Upgrade",
                            "itemTypeCode": "1",
                            "lineOfBusiness": "NS",
                            "moduleDescription": "Dell Services:Extended Service",
                            "parentModuleId": "30",
                            "parentOptionId": "957821",
                            "quantity": 1,
                            "rollupFlag": false,
                            "sequenceNumber": 5,
                            "skuNumber": "710-10844",
                            "subscriptionRatePlanId": null,
                            "subscriptionVersionId": null,
                            "subscriptionId": null,
                            "subAgreementId": null,
                            "optionVpn": null,
                            "selectedCadence": null,
                            "serviceUpsellCode": null,
                            "svcsProc": null,
                            "aggreementId": null
                        }
                    ],
                    "customerSpecificFields": null,
                    "serviceTags": [],
                    "associatedItems": [],
                    "baseSkuNumber": "210-BDTD",
                    "description": "PG,SALOMON TBT MLK,WD22TB4",
                    "orderCode": "RCRC1506172-6210949",
                    "siNumber": null,
                    "itemVersion": "V4",
                    "categories": [
                        {
                            "name": "CONFIG",
                            "id": "root",
                            "description": "CONFIG"
                        },
                        {
                            "name": "ProductLine",
                            "id": "p90",
                            "description": "Dell-Branded Peripherals"
                        },
                        {
                            "name": "Brand",
                            "id": "b90",
                            "description": "Dell-Branded Peripherals"
                        },
                        {
                            "name": "Family",
                            "id": "f16212",
                            "description": "Dell Thunderbolt Dock - WD22TB4"
                        }
                    ],
                    "baseSkuClass": "!(208",
                    "baseSkuClassDescription": "Dell Thunderbolt Dock WD22TB4, 180W",
                    "externalName": "PG,SALOMON TBT MLK,WD22TB4",
                    "cficomments": [],
                    "goalLineId": null,
                    "assets": [],
                    "chassisId": 36135,
                    "productLineId": 90,
                    "isTied": false,
                    "shipsWith": false,
                    "tieNum": null,
                    "rsMultiQuantity": null,
                    "rsParentItemId": null,
                    "isCPScore": false,
                    "callbacks": null
                }
            ],
            "dpid": "7040000330593",
            "aggregateAutoCollectSkus": "{\"340-CKSZ\":\"NO\"}",
            "isMultiPackEnabled": false,
            "itemRelationships": null
        }
    },
    "priceDomain": {
        "resource": {
            "version": "v1",
            "transactionalPriceViewUri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/price-transactional-view/7040000330593",
            "processedPriceViewUri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/price-processed-view/7040000330593",
            "exceptionPriceViewUri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/price-exception-view/7040000330593"
        },
        "summary": null,
        "data": null
    },
    "salesRepDomain": {
        "resource": {
            "version": null,
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/salesrep/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "salesReps": [
                {
                    "id": null,
                    "email": "Ashwini_Manjunathara@Dell.com",
                    "salesPersonNumber": "20000368",
                    "salespersonName": null,
                    "firstName": "ASHWINI",
                    "lastName": "MANJUNATHARA",
                    "middleInitial": null,
                    "phone": {
                        "countryCode": null,
                        "areaCode": null,
                        "number": "1",
                        "phoneType": null,
                        "extension": null
                    },
                    "type": "PRIMARY",
                    "timeStamp": "2022-07-12T14:50:31.663Z",
                    "orgId": null,
                    "userName": null,
                    "effectiveStartDate": "2020-08-17T00:00:00.000Z",
                    "effectiveEndDate": null,
                    "statusFlag": "A",
                    "badgeId": "1216003"
                }
            ]
        },
        "summary": null
    },
    "complianceDomain": {
        "resource": {
            "complianceSnapshotUri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/compliance-snapshot-view/7040000330593",
            "version": "1.0",
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/compliance/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "status": "OPEN",
            "orderType": "TCORDI",
            "salesOrderTradeComplianceUrl": "http://snapshot-svc.g4.dell.com/snapshots/r9W50ud1p0K_Z3WtiqEvjg",
            "schemaVersion": 2,
            "exportForm": {
                "gtpId": null,
                "requiresExportReview": false,
                "sameAddressAsShipping": true,
                "exportIntent": false,
                "questions": [
                    {
                        "id": null,
                        "questionText": "Country of End User",
                        "questionFormat": "SingleChoice",
                        "answer": null,
                        "answers": [
                            {
                                "id": null,
                                "answerText": "GB"
                            }
                        ]
                    },
                    {
                        "id": null,
                        "questionText": "How will these products be used?",
                        "questionFormat": "SingleChoice",
                        "answer": null,
                        "answers": [
                            {
                                "id": null,
                                "answerText": "HM:Home"
                            }
                        ]
                    },
                    {
                        "id": null,
                        "questionText": "Where will these products be used?",
                        "questionFormat": "SingleChoice",
                        "answer": null,
                        "answers": [
                            {
                                "id": null,
                                "answerText": "export_no : I do not want to export outside Great Britain"
                            }
                        ]
                    }
                ],
                "endUse": "Home",
                "exportFlag": "",
                "country": "GB"
            }
        },
        "summary": null
    },
    "customerCommitmentDomain": {
        "resource": {
            "version": "1.0",
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/customercommitment/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "dpecorrelationId": "8fd2dd3c-36df-41c9-ac48-9ee29921b003",
            "customerCommitmentInfo": {
                "estimatedShippingDateMin": "2023-05-15T13:20:00Z",
                "estimatedShippingDateMax": "2023-05-17T13:20:00Z",
                "estimatedDeliveryDateMin": "2023-05-15T13:20:00Z",
                "estimatedDeliveryDateMax": "2023-05-24T13:20:00Z",
                "estimatedShipmentDaysRangeMin": 0,
                "estimatedShipmentDaysRangeMax": 0,
                "estimatedDeliveryDaysRangeMin": 0,
                "estimatedDeliveryDaysRangeMax": 0,
                "baseDate": "0001-01-01T00:00:00Z",
                "shiftEnabled": false,
                "leadTimeUnits": "LeadtimeUnits",
                "deliveryShifts": "DeliveryShifts",
                "maxSkuLTDetail": "DEFAULT_8",
                "leadTimeBreakUp": "CorrelationId=\"8fd2dd3c-36df-41c9-ac48-9ee29921b003\";PLT=6;PLTHoliday=2;CFI=0;PlannedEvent=0;SILeadDays=0;ProDeploy=0;BOF=0;ExtendedLeadDays=5;MLT=8;MLTHoliday=0;MaxLeadtimeSku=\"DEFAULT_8\";BaseOrProxySku_LT=\"DEFAULT_3_5\";IsMaxSkuRunningOnAutoLeadTime=\"False\";IsSkuOnTh=\"F\";MaxAutoLeadTimeSku=\"NA\";RESD=\"NA\";PRODUCTTYPE=\"BTO\";SITE=\"TIL_BTO\";ItemId=\"1e9fffdd-a63e-47ac-b68b-8db5619c7ccb\";IBChoice=\"AR\";LLT=5;LLTHoliday=2;ShuttleLeadDays=0;CFS=0;DeliveryPlus=0;ShuttleHolidays=0;DeliveryCaption=\"Arrives\";DRSRule=\"OPTIPLEX FOR UK\";CDSAdder=0;Choice=\"IY\";",
                "esadMin": "0001-01-01T00:00:00Z",
                "esadMax": "0001-01-01T00:00:00Z",
                "mustArriveByDate": null,
                "futuristicDeliveryDate": null,
                "cceEnabled": true,
                "shipFlag": null,
                "manufacturingLeadDays": 0
            },
            "items": [
                {
                    "id": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                    "manufacturingMethod": "MFG_METHOD",
                    "coIntellectualProperty": "CoIntellectualProperty",
                    "customerCommitment": {
                        "estimatedShippingDateMin": "2023-05-15T13:20:00Z",
                        "estimatedShippingDateMax": "2023-05-17T13:20:00Z",
                        "estimatedDeliveryDateMin": "2023-05-15T13:20:00Z",
                        "estimatedDeliveryDateMax": "2023-05-24T13:20:00Z",
                        "estimatedShipmentDaysRangeMin": 0,
                        "estimatedShipmentDaysRangeMax": 0,
                        "estimatedDeliveryDaysRangeMin": 0,
                        "estimatedDeliveryDaysRangeMax": 0,
                        "baseDate": "0001-01-01T00:00:00Z",
                        "shiftEnabled": false,
                        "leadTimeUnits": "LeadtimeUnits",
                        "deliveryShifts": "DeliveryShifts",
                        "maxSkuLTDetail": "DEFAULT_8",
                        "leadTimeBreakUp": "CorrelationId=\"8fd2dd3c-36df-41c9-ac48-9ee29921b003\";PLT=6;PLTHoliday=2;CFI=0;PlannedEvent=0;SILeadDays=0;ProDeploy=0;BOF=0;ExtendedLeadDays=5;MLT=8;MLTHoliday=0;MaxLeadtimeSku=\"DEFAULT_8\";BaseOrProxySku_LT=\"DEFAULT_3_5\";IsMaxSkuRunningOnAutoLeadTime=\"False\";IsSkuOnTh=\"F\";MaxAutoLeadTimeSku=\"NA\";RESD=\"NA\";PRODUCTTYPE=\"BTO\";SITE=\"TIL_BTO\";ItemId=\"1e9fffdd-a63e-47ac-b68b-8db5619c7ccb\";IBChoice=\"AR\";LLT=5;LLTHoliday=2;ShuttleLeadDays=0;CFS=0;DeliveryPlus=0;ShuttleHolidays=0;DeliveryCaption=\"Arrives\";DRSRule=\"OPTIPLEX FOR UK\";CDSAdder=0;Choice=\"IY\";",
                        "esadMin": "0001-01-01T00:00:00Z",
                        "esadMax": "0001-01-01T00:00:00Z",
                        "mustArriveByDate": null,
                        "futuristicDeliveryDate": null,
                        "cceEnabled": true,
                        "shipFlag": null,
                        "manufacturingLeadDays": 0
                    }
                },
                {
                    "id": "a81e4b06-3981-47b7-a506-962476d72bca",
                    "manufacturingMethod": "MFG_METHOD",
                    "coIntellectualProperty": "CoIntellectualProperty",
                    "customerCommitment": {
                        "estimatedShippingDateMin": "0001-01-01T00:00:00Z",
                        "estimatedShippingDateMax": "2023-05-15T13:20:00Z",
                        "estimatedDeliveryDateMin": "0001-01-01T00:00:00Z",
                        "estimatedDeliveryDateMax": "2023-05-19T13:20:00Z",
                        "estimatedShipmentDaysRangeMin": 0,
                        "estimatedShipmentDaysRangeMax": 0,
                        "estimatedDeliveryDaysRangeMin": 0,
                        "estimatedDeliveryDaysRangeMax": 0,
                        "baseDate": "0001-01-01T00:00:00Z",
                        "shiftEnabled": false,
                        "leadTimeUnits": "LeadtimeUnits",
                        "deliveryShifts": "DeliveryShifts",
                        "maxSkuLTDetail": "450-AICE_1",
                        "leadTimeBreakUp": "CorrelationId=\"8fd2dd3c-36df-41c9-ac48-9ee29921b003\";PLT=6;PLTHoliday=2;SITE=\"TIL\";MLT=1;ExtendedLeadDays=0;MLTHoliday=2;CFI=0;ProDeploy=0;MaxLeadtimeSku=\"450-AICE_1\";BaseOrProxySku_LT=\"450-AICE_1_0\";IsAPOS=\"True\";IsMaxSkuRunningOnAutoLeadTime=\"False\";IsSkuOnTh=\"F\";MaxAutoLeadTimeSku=\"NA\";RESD=\"NA\";PRODUCTTYPE=\"SNA\";ItemId=\"a81e4b06-3981-47b7-a506-962476d72bca\";IBChoice=\"NA\";LLT=4;LLTHoliday=0;DeliveryPlus=0;CFS=0;DeliveryCaption=\"ArrivesBy\";DRSRule=\"ALL ORDERS WITH SNA PRODUCTS\";CDSAdder=0;Choice=\"IY\";",
                        "esadMin": "0001-01-01T00:00:00Z",
                        "esadMax": "0001-01-01T00:00:00Z",
                        "mustArriveByDate": null,
                        "futuristicDeliveryDate": null,
                        "cceEnabled": true,
                        "shipFlag": null,
                        "manufacturingLeadDays": 0
                    }
                }
            ],
            "shipments": [
                {
                    "itemInfo": [
                        {
                            "siteCode": "TIL_BTO",
                            "id": "v0yaZkNU7UelAqXfUmTNFA",
                            "openBasketItemId": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb"
                        },
                        {
                            "siteCode": "TIL",
                            "id": "bZfI9S1mj0-ETNiHHD4JhQ",
                            "openBasketItemId": "a81e4b06-3981-47b7-a506-962476d72bca"
                        }
                    ]
                }
            ],
            "fulfillmentUnits": [
                {
                    "id": "3823d615-841a-4bdd-8639-bfb40567d320",
                    "orderTypeId": null,
                    "shipFlag": null,
                    "orderType": null,
                    "itemInfo": [
                        {
                            "id": "1e9fffdd-a63e-47ac-b68b-8db5619c7ccb",
                            "quantity": "1"
                        }
                    ],
                    "siteCode": "TIL_BTO",
                    "customerCommitment": {
                        "estimatedShippingDateMin": "2023-05-15T13:20:00Z",
                        "estimatedShippingDateMax": "2023-05-17T13:20:00Z",
                        "estimatedDeliveryDateMin": "2023-05-15T13:20:00Z",
                        "estimatedDeliveryDateMax": "2023-05-24T13:20:00Z",
                        "estimatedShipmentDaysRangeMin": 0,
                        "estimatedShipmentDaysRangeMax": 0,
                        "estimatedDeliveryDaysRangeMin": 0,
                        "estimatedDeliveryDaysRangeMax": 0,
                        "baseDate": "0001-01-01T00:00:00Z",
                        "shiftEnabled": null,
                        "leadTimeUnits": null,
                        "deliveryShifts": null,
                        "maxSkuLTDetail": null,
                        "leadTimeBreakUp": "CorrelationId=\"8fd2dd3c-36df-41c9-ac48-9ee29921b003\";PLT=6;PLTHoliday=2;CFI=0;PlannedEvent=0;SILeadDays=0;ProDeploy=0;BOF=0;ExtendedLeadDays=5;MLT=8;MLTHoliday=0;MaxLeadtimeSku=\"DEFAULT_8\";BaseOrProxySku_LT=\"DEFAULT_3_5\";IsMaxSkuRunningOnAutoLeadTime=\"False\";IsSkuOnTh=\"F\";MaxAutoLeadTimeSku=\"NA\";RESD=\"NA\";PRODUCTTYPE=\"BTO\";SITE=\"TIL_BTO\";ItemId=\"1e9fffdd-a63e-47ac-b68b-8db5619c7ccb\";IBChoice=\"AR\";LLT=5;LLTHoliday=2;ShuttleLeadDays=0;CFS=0;DeliveryPlus=0;ShuttleHolidays=0;DeliveryCaption=\"Arrives\";DRSRule=\"OPTIPLEX FOR UK\";CDSAdder=0;Choice=\"IY\";",
                        "esadMin": "0001-01-01T00:00:00Z",
                        "esadMax": "0001-01-01T00:00:00Z",
                        "mustArriveByDate": null,
                        "futuristicDeliveryDate": null,
                        "cceEnabled": false,
                        "shipFlag": null,
                        "manufacturingLeadDays": 0
                    }
                },
                {
                    "id": "b68e9bdf-5eee-435c-a267-bef7e783ea04",
                    "orderTypeId": null,
                    "shipFlag": null,
                    "orderType": null,
                    "itemInfo": [
                        {
                            "id": "a81e4b06-3981-47b7-a506-962476d72bca",
                            "quantity": "1"
                        }
                    ],
                    "siteCode": "TIL",
                    "customerCommitment": {
                        "estimatedShippingDateMin": "0001-01-01T00:00:00Z",
                        "estimatedShippingDateMax": "2023-05-15T13:20:00Z",
                        "estimatedDeliveryDateMin": "0001-01-01T00:00:00Z",
                        "estimatedDeliveryDateMax": "2023-05-19T13:20:00Z",
                        "estimatedShipmentDaysRangeMin": 0,
                        "estimatedShipmentDaysRangeMax": 0,
                        "estimatedDeliveryDaysRangeMin": 0,
                        "estimatedDeliveryDaysRangeMax": 0,
                        "baseDate": "0001-01-01T00:00:00Z",
                        "shiftEnabled": null,
                        "leadTimeUnits": null,
                        "deliveryShifts": null,
                        "maxSkuLTDetail": null,
                        "leadTimeBreakUp": "CorrelationId=\"8fd2dd3c-36df-41c9-ac48-9ee29921b003\";PLT=6;PLTHoliday=2;SITE=\"TIL\";MLT=1;ExtendedLeadDays=0;MLTHoliday=2;CFI=0;ProDeploy=0;MaxLeadtimeSku=\"450-AICE_1\";BaseOrProxySku_LT=\"450-AICE_1_0\";IsAPOS=\"True\";IsMaxSkuRunningOnAutoLeadTime=\"False\";IsSkuOnTh=\"F\";MaxAutoLeadTimeSku=\"NA\";RESD=\"NA\";PRODUCTTYPE=\"SNA\";ItemId=\"a81e4b06-3981-47b7-a506-962476d72bca\";IBChoice=\"NA\";LLT=4;LLTHoliday=0;DeliveryPlus=0;CFS=0;DeliveryCaption=\"ArrivesBy\";DRSRule=\"ALL ORDERS WITH SNA PRODUCTS\";CDSAdder=0;Choice=\"IY\";",
                        "esadMin": "0001-01-01T00:00:00Z",
                        "esadMax": "0001-01-01T00:00:00Z",
                        "mustArriveByDate": null,
                        "futuristicDeliveryDate": null,
                        "cceEnabled": false,
                        "shipFlag": null,
                        "manufacturingLeadDays": 0
                    }
                }
            ],
            "osemErrorReason": {
                "errorDescription": null
            }
        },
        "summary": null
    },
    "contractDomain": {
        "resource": {
            "version": "1.0",
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/contract/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "goalLiteDealId": null,
            "items": null
        },
        "summary": null
    },
    "fraudPreventionDomain": {
        "resource": {
            "fraudPreventionSnapshotUri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/fraudprevention-snapshot-view/7040000330593",
            "version": "1.0",
            "uri": "https://omcs-global-order-external-ge4.omcs-nonprod.r1.pks.dell.com/omcs-global-order-external/api/v1/fraudprevention/7040000330593"
        },
        "data": {
            "dpid": "7040000330593",
            "context": {
                "fraudNumber": "",
                "fraudIndicator": "N",
                "fraudType": ""
            },
            "threatMetrix": {
                "id": "",
                "event": "",
                "org": ""
            }
        },
        "summary": null
    },
    "versionInformation": {}
}
```

# Cart

# Item
##### Sample OBLite 
APOS (SE Item) : [http://item-snapshot.dellsvc/v1/items/JdXbgfZp70emGH2Sar1p2g~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/JdXbgfZp70emGH2Sar1p2g~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/jdxbgfzp70emgh2sar1p2g~001/openbasketlite")  
Spares_V4 : [http://item-snapshot.dellsvc/v1/items/9GwZPO5pEUmnrW95pP68LQ~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/9GwZPO5pEUmnrW95pP68LQ~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/9gwzpo5peumnrw95pp68lq~001/openbasketlite")  
OrderCode_V4 : [http://item-snapshot.dellsvc/v1/items/_uXFnZ4of0yBNSWzBpiF7Q~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/_uXFnZ4of0yBNSWzBpiF7Q~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/_uxfnz4of0ybnswzbpif7q~001/openbasketlite")  
Cuskit_V4: [http://item-snapshot.dellsvc/v1/items/Fh8GizCLXk2R3UDUuZ7JQg~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/Fh8GizCLXk2R3UDUuZ7JQg~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/fh8gizclxk2r3uduuz7jqg~001/openbasketlite")  
Service_V4:  
[http://item-snapshot.dellsvc/v1/items/pqXWdhoLLEOcdsv-kykrUg~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/pqXWdhoLLEOcdsv-kykrUg~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/pqxwdholleocdsv-kykrug~001/openbasketlite")  
SnP_V4:  
[http://item-snapshot.dellsvc/v1/items/Mah9gyaMHU2sZljWeJEq6g~001/openBasketLite](http://item-snapshot.dellsvc/v1/items/Mah9gyaMHU2sZljWeJEq6g~001/openBasketLite "http://item-snapshot.dellsvc/v1/items/mah9gyamhu2szljwejeq6g~001/openbasketlite")
##### SubscriptionOffer_V4 item request payload
```json
{
  "commerceContext": {
    "region": "US",
    "country": "US",
    "language": "EN",
    "currency": "USD",
    "displayCurrency": "",
    "customerSet": "rc1387181",
    "segment": "IC",
    "sourceApplicationName": "DSP",
    "companyNumber": "8",
    "businessUnitId": "11"
  },
  "quantity": 1,
  "type": "SubscriptionOffer_V4",
  
  "configuredSelections": "{\r\n    \"id\": \"AAAAA386STUBATTR\",\r\n    \"instanceId\": \"a8b538d9-60ba-4f64-b059-079a047ace5b\",\r\n    \"authoringVersion\": \"2.0.0\",\r\n    \"selectionGroups\": [\r\n      {\r\n        \"id\": \"Core\",\r\n        \"selections\": [\r\n          {\r\n            \"id\": \"aaaaa387\",\r\n            \"instanceId\": \"a8b538d9-60ba-4f64-b059-079a047ace5b\",\r\n            \"selected\": true,\r\n            \"authoringVersion\": \"2.0.0\",\r\n            \"selectionGroups\": [\r\n              {\r\n                \"id\": \"OFFQuantity\",\r\n                \"dimensions\": {\r\n                  \"range\": {\r\n                    \"value\": 10\r\n                  }\r\n                }\r\n              },\r\n              {\r\n                \"id\": \"SUPPORT_LEVEL\",\r\n                \"selections\": [\r\n                  {\r\n                    \"id\": \"BASIC\",\r\n                    \"selected\": true\r\n                  }\r\n                ],\r\n                \"dimensions\": null\r\n              }\r\n            ],\r\n            \"selectors\": {\r\n              \"OFFBillCad\": \"M\",\r\n              \"Term\": 12,\r\n              \"SUPPORT_LEVEL\": \"BASIC\",\r\n              \"OFFQuantity\": 10\r\n            },\r\n            \"customization\": {\r\n              \"customer\": {\r\n                \"dellCustomerId\": \"550000257458\"\r\n              },\r\n              \"snapshotProperties\": {\r\n                \r\n              },\r\n              \"subscription\": {\r\n                \"rate\": {\r\n                  \"discountPercentage\": 0.0,\r\n                  \"contract\": {\r\n                    \"contractStart\": 0,\r\n                    \"contractEnd\": 0,\r\n                    \"priceTerms\": [\r\n                      {\r\n                        \"termDuration\": 0,\r\n                        \"termDurationUOM\": \"F\"\r\n                      }\r\n                    ]\r\n                  }\r\n                }\r\n              }\r\n            },\r\n            \"entitlement\": {\r\n              \"subscription\": {\r\n                \"selectionGroups\": [\r\n                  {\r\n                    \"id\": \"OFFBillCad\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"M\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  },\r\n                  {\r\n                    \"id\": \"Term\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"12\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  },\r\n                  {\r\n                    \"id\": \"OFFAutoRenewalFlag\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"OptIn\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  }\r\n                ]\r\n              }\r\n            }\r\n          }\r\n        ],\r\n        \"dimensions\": null\r\n      },\r\n      {\r\n        \"id\": \"Optional\",\r\n        \"selections\": [\r\n          {\r\n            \"id\": \"aaaaa388\",\r\n            \"instanceId\": \"a8b538d9-60ba-4f64-b059-079a047ace5b\",\r\n            \"selected\": true,\r\n            \"authoringVersion\": \"2.0.0\",\r\n            \"selectionGroups\": [\r\n              {\r\n                \"id\": \"OFFQuantity\",\r\n                \"dimensions\": {\r\n                  \"range\": {\r\n                    \"value\": 10\r\n                  }\r\n                }\r\n              },\r\n              {\r\n                \"id\": \"SUPPORT_LEVEL\",\r\n                \"selections\": [\r\n                  {\r\n                    \"id\": \"BASIC\",\r\n                    \"selected\": true\r\n                  }\r\n                ],\r\n                \"dimensions\": null\r\n              }\r\n            ],\r\n            \"selectors\": {\r\n              \"OFFBillCad\": \"M\",\r\n              \"Term\": 12,\r\n              \"SUPPORT_LEVEL\": \"BASIC\",\r\n              \"OFFQuantity\": 10\r\n            },\r\n            \"customization\": {\r\n              \"customer\": {\r\n                \"dellCustomerId\": \"550000257458\"\r\n              },\r\n              \"snapshotProperties\": {\r\n                \r\n              },\r\n              \"subscription\": {\r\n                \"rate\": {\r\n                  \"discountPercentage\": 0.0,\r\n                  \"contract\": {\r\n                    \"contractStart\": 0,\r\n                    \"contractEnd\": 0,\r\n                    \"priceTerms\": [\r\n                      {\r\n                        \"termDuration\": 0,\r\n                        \"termDurationUOM\": \"F\"\r\n                      }\r\n                    ]\r\n                  }\r\n                }\r\n              }\r\n            },\r\n            \"entitlement\": {\r\n              \"subscription\": {\r\n                \"selectionGroups\": [\r\n                  {\r\n                    \"id\": \"OFFBillCad\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"M\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  },\r\n                  {\r\n                    \"id\": \"Term\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"12\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  },\r\n                  {\r\n                    \"id\": \"OFFAutoRenewalFlag\",\r\n                    \"selections\": [\r\n                      {\r\n                        \"id\": \"OptIn\",\r\n                        \"selected\": true\r\n                      }\r\n                    ],\r\n                    \"dimensions\": null\r\n                  }\r\n                ]\r\n              }\r\n            }\r\n          }\r\n        ],\r\n        \"dimensions\": null\r\n      }\r\n    ],\r\n    \"customization\": {\r\n      \"customer\": {\r\n        \"dellCustomerId\": \"550000257458\"\r\n      },\r\n      \"snapshotProperties\": {\r\n        \r\n      },\r\n      \"subscription\": {\r\n        \"id\": \"\",\r\n        \"version\": \"\",\r\n        \"solutionTransactionType\": \"NEW_SUBSCRIPTION\"\r\n      }\r\n    }\r\n  }"
  
}
```

# SalesOrder
### Prod
##### GET SalesOrder output
```json
{
  "id": "string",
  "orderCreateDate": "2023-07-05T21:57:55.355Z",
  "lastModifiedOn": "2023-07-05T21:57:55.355Z",
  "quoteUrl": "string",
  "orderDpid": "string",
  "orderDpidVersion": 0,
  "fulfillmentUnitsUrl": "string",
  "status": "Edit",
  "exportCompliance": {
    "exportIntent": "No",
    "exportForm": {
      "questions": [
        {
          "id": "string",
          "answers": [
            "string"
          ],
          "questionFormat": "FreeResponse",
          "questionText": "string"
        }
      ],
      "sameAddressAsShipping": true,
      "requiresExportReview": true,
      "country": "string",
      "contact": {
        "additionalEmails": [
          {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          }
        ],
        "digitalFulfillmentEmail": "string",
        "warrantyEmailAddress": "string",
        "address": {
          "addressType": "General",
          "city": "string",
          "cityCode": "string",
          "country": "string",
          "countryCode": 0,
          "geoCode": "string",
          "id": "string",
          "isValid": true,
          "isAddressVerified": true,
          "line1": "string",
          "line2": "string",
          "line3": "string",
          "line4": "string",
          "line5": "string",
          "other1": "string",
          "other2": "string",
          "other3": "string",
          "other4": "string",
          "other5": "string",
          "postalCode": "string",
          "suburb": "string",
          "region": "string",
          "regionName": "string",
          "sequenceNumber": "string"
        },
        "camId": "string",
        "camLocationId": "string",
        "companyName": "string",
        "contactId": "string",
        "contactType": "Undefined",
        "customerNumber": "string",
        "department": "string",
        "emailAddress": "string",
        "emailType": "string",
        "endUserInfo": {
          "customerAccountId": "string",
          "endUserEmail": {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          },
          "endUserId": "string",
          "omsCustomerId": "string",
          "partnerRequestId": "string",
          "partnerRequestStatus": "string",
          "partyId": "string",
          "salesChannelId": "string"
        },
        "fax": {
          "countryCode": "string",
          "areaCode": "string",
          "number": "string",
          "phoneType": "string",
          "extension": "string"
        },
        "isValid": true,
        "linkNumber": "string",
        "firstName": "string",
        "middleName": "string",
        "lastName": "string",
        "prefix": "string",
        "suffix": "string",
        "title": "string",
        "organizationInfo": {
          "branchName": "string",
          "companyRegistrationDate": "string",
          "companyRegistrationNo": "string",
          "department": "string",
          "fields": {
            "additionalProp1": "string",
            "additionalProp2": "string",
            "additionalProp3": "string"
          },
          "id": "string",
          "name": "string",
          "secondaryName": "string",
          "taxNo": "string",
          "title": "string",
          "type": "string"
        },
        "phoneContacts": [
          {
            "countryCode": "string",
            "areaCode": "string",
            "number": "string",
            "phoneType": "string",
            "extension": "string"
          }
        ],
        "properties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "secondaryName": {
          "first": "string",
          "last": "string",
          "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
          "mi": "string",
          "prefix": "string",
          "suffix": "string",
          "title": "string"
        },
        "taxIdPrimary": "string",
        "taxIdSecondary": "string",
        "ucid": "string",
        "optInFlags": 0,
        "marketingPreferences": {
          "additionalProp1": true,
          "additionalProp2": true,
          "additionalProp3": true
        },
        "taxCategory": "string",
        "invoiceType": "string",
        "bankName": "string",
        "accountId": "string",
        "accountNumber": "string",
        "accountName": "string",
        "carrierType": "string",
        "carrierID": "string",
        "taxRegNo": "string",
        "cpfGroupId": "string",
        "language": "string",
        "invoiceDeliveryMethod": "string"
      }
    }
  },
  "customerCommunication": {
    "orderConfirmationKey": "string",
    "orderConfirmation": "string",
    "orderAcknowledgementKey": "string",
    "orderAcknowledgement": "string",
    "hideSku": true,
    "cfoPreferences": [
      {
        "cfoTypes": [
          "string"
        ],
        "language": "string",
        "format": "string",
        "method": "string",
        "sendCfo": true,
        "toRecipients": "string",
        "ccRecipients": "string",
        "properties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        }
      }
    ]
  },
  "exchangeInfo": {
    "dpsNumber": "string",
    "exchangeReasonCode": "string",
    "exchangeType": "string",
    "mwdType": "string",
    "originalOrderNumber": "string",
    "fsrNumber": "string"
  },
  "insuredReturns": {
    "fusionId": "string",
    "code": "string",
    "comments": "string",
    "pomId": "string"
  },
  "price": {
    "detailedViewUrl": "string",
    "priceRequestUrl": "string",
    "priceStoreViewUrl": "string",
    "reportingViewUrl": "string",
    "shippingViewUrl": "string",
    "summaryViewUrl": "string",
    "taxInformation": {
      "isExempt": true,
      "exemptTaxType": "string",
      "taxExemptCode": "string",
      "taxOverrideFlag": "string",
      "taxOverrideReasonCode": "string",
      "primaryTaxId": "string",
      "taxCategory": "string",
      "shipToTaxCategory": "string"
    }
  },
  "priceSummary": {
    "listPrice": 0,
    "sellingPrice": 0,
    "discount": 0,
    "discountPercentage": 0,
    "totalMargin": 0,
    "marginPercentage": 0,
    "adjustedShipping": 0,
    "unadjustedShipping": 0,
    "shippingDiscount": 0,
    "taxAndShippingTax": 0,
    "ecoFee": 0,
    "subTotal": 0,
    "finalPrice": 0
  },
  "reservation": {
    "expirationTime": 0,
    "lookupId": "string",
    "lookupIdType": "string",
    "updateId": "string",
    "updateIdType": "string",
    "updateUid": "string"
  },
  "properties": {
    "additionalProp1": "string",
    "additionalProp2": "string",
    "additionalProp3": "string"
  },
  "extendedProperties": {
    "additionalProp1": "string",
    "additionalProp2": "string",
    "additionalProp3": "string"
  },
  "extensionData": {
    "orderType": "string",
    "poNumber": "string",
    "pomId": "string",
    "poDateReceived": "2023-07-05T21:57:55.356Z",
    "selectedCadence": "string",
    "linkToReenteredDpid": "string",
    "createdBy": "string",
    "goalDealId": "string",
    "sfdcDealId": "string",
    "isZeroPriceOverride": true,
    "confirmationEmailFormat": "string"
  },
  "endUserInfo": {
    "address": {
      "addressType": "General",
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "geoCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "regionName": "string",
      "sequenceNumber": "string"
    },
    "customerAccountId": "string",
    "emailAddress": "string",
    "id": "string",
    "omsCustomerId": "string",
    "partyId": "string",
    "requestId": "string",
    "requestStatus": "string",
    "salesChannelId": "string"
  },
  "endUser": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "General",
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "geoCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "regionName": "string",
      "sequenceNumber": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "Undefined",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxCategory": "string",
    "invoiceType": "string",
    "bankName": "string",
    "accountId": "string",
    "accountNumber": "string",
    "accountName": "string",
    "carrierType": "string",
    "carrierID": "string",
    "taxRegNo": "string",
    "cpfGroupId": "string",
    "language": "string",
    "invoiceDeliveryMethod": "string"
  },
  "soldTo": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "General",
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "geoCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "regionName": "string",
      "sequenceNumber": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "Undefined",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxCategory": "string",
    "invoiceType": "string",
    "bankName": "string",
    "accountId": "string",
    "accountNumber": "string",
    "accountName": "string",
    "carrierType": "string",
    "carrierID": "string",
    "taxRegNo": "string",
    "cpfGroupId": "string",
    "language": "string",
    "invoiceDeliveryMethod": "string"
  },
  "deliveryTo": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "General",
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "geoCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "regionName": "string",
      "sequenceNumber": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "Undefined",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxCategory": "string",
    "invoiceType": "string",
    "bankName": "string",
    "accountId": "string",
    "accountNumber": "string",
    "accountName": "string",
    "carrierType": "string",
    "carrierID": "string",
    "taxRegNo": "string",
    "cpfGroupId": "string",
    "language": "string",
    "invoiceDeliveryMethod": "string"
  },
  "billTo": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "General",
      "city": "string",
      "cityCode": "string",
      "country": "string",
      "countryCode": 0,
      "geoCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "regionName": "string",
      "sequenceNumber": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "Undefined",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxCategory": "string",
    "invoiceType": "string",
    "bankName": "string",
    "accountId": "string",
    "accountNumber": "string",
    "accountName": "string",
    "carrierType": "string",
    "carrierID": "string",
    "taxRegNo": "string",
    "cpfGroupId": "string",
    "language": "string",
    "invoiceDeliveryMethod": "string"
  },
  "items": [
    {
      "id": "string",
      "openBasketItemId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "skus": [
        {
          "skuNumber": "string",
          "selectedCadence": "string"
        }
      ],
      "customerSpecificFields": [
        {
          "fieldKey": "string",
          "fieldValue": "string",
          "nameSpace": "string"
        }
      ],
      "openBasketLiteUrl": "string",
      "stockReservationId": "string",
      "extendedProperties": [
        {
          "key": "string",
          "namespace": "string",
          "value": "string"
        }
      ],
      "metadata": [
        {
          "id": "string",
          "node": {
            "id": "string",
            "type": "string",
            "child": "string",
            "customFields": [
              {
                "key": "string",
                "value": "string"
              }
            ]
          }
        }
      ],
      "assets": [
        {
          "isParentAsset": true,
          "targetAssetId": "string",
          "targetAssetType": "string"
        }
      ],
      "txProductUrl": "string",
      "txShopPriceUrl": "string",
      "txMiscellaneousUrl": "string",
      "type": "OrderCode"
    }
  ],
  "salesReps": [
    {
      "id": "string",
      "email": "string",
      "employeeId": "string",
      "salesPersonNumber": "string",
      "firstName": "string",
      "lastName": "string",
      "middleInitial": "string",
      "phone": {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      },
      "type": "Secondary",
      "source": "string"
    }
  ],
  "holdReasons": [
    {
      "key": "string",
      "code": "string"
    }
  ],
  "paymentMethods": [
    {
      "id": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "amount": 0,
      "billPlanId": "string",
      "globalPaymentId": "string",
      "payCode": "string",
      "netTerm": "string",
      "isRecurringPayment": true,
      "paymentDescription": "string",
      "typeOfFunds": "string",
      "typeOfInstrument": "string",
      "leasingTerm": "string",
      "creditCardType": "string",
      "creditRating": 0,
      "pricingPaymentMethod": "CreditCard",
      "originalOrderNumber": "string",
      "comments": "string",
      "isCCVerified": true,
      "subscriptionServiceType": [
        "string"
      ],
      "backendPayCode": "string",
      "leaseAgreementNumber": "string",
      "isPrepaid": true,
      "isLease": true,
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "extendedProperties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "referenceNumber": "string",
      "paymentReceiptNumber": "string",
      "payerName": "string",
      "payeeAmount": 0,
      "isInterestApplied": true,
      "emiAmountExcludingInstallmentCharges": 0,
      "emiAmountPerInstallment": 0,
      "emiNumberOfInstallments": 0
    }
  ],
  "authorizedPayments": "string",
  "impactIdsToDelete": [
    {
      "fulfillmentUnitId": "string",
      "paymentMethodId": "string",
      "amount": 0,
      "authStatusCode": "string",
      "paymentAuthorization": {
        "authorizedAmount": 0,
        "authApprovalError": true,
        "authApproved": true,
        "authBankMessage": "string",
        "authCustomerMessage": "string",
        "authDate": "string",
        "authenticationResult": "string",
        "authErrorMessage": "string",
        "authExactMessage": "string",
        "authNumber": "string",
        "authorizationCode": "string",
        "authorizationStatus": {
          "isComplete": true,
          "reasons": [
            "string"
          ],
          "sequence": 0,
          "state": "string",
          "subStatus": [
            "string"
          ],
          "taskCodes": [
            "string"
          ],
          "time": "2023-07-05T21:57:55.357Z"
        },
        "authProofMessages": [
          "string"
        ],
        "authStatusCode": "string",
        "status": "string"
      }
    }
  ],
  "leadTimeDetails": [
    {
      "openBasketItemId": "string",
      "baseDate": "2023-07-05T21:57:55.357Z",
      "cceEnabled": true,
      "estimatedDeliveryDateRange": {
        "min": "2023-07-05T21:57:55.357Z",
        "max": "2023-07-05T21:57:55.357Z"
      },
      "estimatedShipDateRange": {
        "min": "2023-07-05T21:57:55.357Z",
        "max": "2023-07-05T21:57:55.357Z"
      },
      "leadTimeBreakUp": "string",
      "shiftEnabled": true,
      "estimatedDeliveryDays": {
        "min": 0,
        "max": 0
      },
      "estimatedShipDays": {
        "min": 0,
        "max": 0
      },
      "maxLeadTimeSku": "string",
      "shipFlag": "string",
      "estimatedServiceActivationDateRange": {
        "min": "2023-07-05T21:57:55.357Z",
        "max": "2023-07-05T21:57:55.357Z"
      },
      "geoCode": "string",
      "manufacturingLeadDays": 0
    }
  ],
  "linkToCancelledOrder": {
    "dpid": 0,
    "omsNumbers": [
      0
    ],
    "quoteNumber": "string",
    "quoteVersion": 0
  },
  "fulfillmentUnitsMetadata": [
    {
      "fulfillmentUnitId": "string",
      "dispositionCode": "string",
      "orderNumbers": [
        "string"
      ]
    }
  ],
  "shipments": [
    {
      "id": "string",
      "shippingMethod": "string",
      "inboundShipMethod": "string",
      "arriveByDate": "2023-07-05T21:57:55.357Z",
      "futuristicDeliveryDate": "2023-07-05T21:57:55.357Z",
      "instructions": "string",
      "shippingContact": {
        "additionalEmails": [
          {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          }
        ],
        "digitalFulfillmentEmail": "string",
        "warrantyEmailAddress": "string",
        "address": {
          "addressType": "General",
          "city": "string",
          "cityCode": "string",
          "country": "string",
          "countryCode": 0,
          "geoCode": "string",
          "id": "string",
          "isValid": true,
          "isAddressVerified": true,
          "line1": "string",
          "line2": "string",
          "line3": "string",
          "line4": "string",
          "line5": "string",
          "other1": "string",
          "other2": "string",
          "other3": "string",
          "other4": "string",
          "other5": "string",
          "postalCode": "string",
          "suburb": "string",
          "region": "string",
          "regionName": "string",
          "sequenceNumber": "string"
        },
        "camId": "string",
        "camLocationId": "string",
        "companyName": "string",
        "contactId": "string",
        "contactType": "Undefined",
        "customerNumber": "string",
        "department": "string",
        "emailAddress": "string",
        "emailType": "string",
        "endUserInfo": {
          "customerAccountId": "string",
          "endUserEmail": {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          },
          "endUserId": "string",
          "omsCustomerId": "string",
          "partnerRequestId": "string",
          "partnerRequestStatus": "string",
          "partyId": "string",
          "salesChannelId": "string"
        },
        "fax": {
          "countryCode": "string",
          "areaCode": "string",
          "number": "string",
          "phoneType": "string",
          "extension": "string"
        },
        "isValid": true,
        "linkNumber": "string",
        "firstName": "string",
        "middleName": "string",
        "lastName": "string",
        "prefix": "string",
        "suffix": "string",
        "title": "string",
        "organizationInfo": {
          "branchName": "string",
          "companyRegistrationDate": "string",
          "companyRegistrationNo": "string",
          "department": "string",
          "fields": {
            "additionalProp1": "string",
            "additionalProp2": "string",
            "additionalProp3": "string"
          },
          "id": "string",
          "name": "string",
          "secondaryName": "string",
          "taxNo": "string",
          "title": "string",
          "type": "string"
        },
        "phoneContacts": [
          {
            "countryCode": "string",
            "areaCode": "string",
            "number": "string",
            "phoneType": "string",
            "extension": "string"
          }
        ],
        "properties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "secondaryName": {
          "first": "string",
          "last": "string",
          "maGuid": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
          "mi": "string",
          "prefix": "string",
          "suffix": "string",
          "title": "string"
        },
        "taxIdPrimary": "string",
        "taxIdSecondary": "string",
        "ucid": "string",
        "optInFlags": 0,
        "marketingPreferences": {
          "additionalProp1": true,
          "additionalProp2": true,
          "additionalProp3": true
        },
        "taxCategory": "string",
        "invoiceType": "string",
        "bankName": "string",
        "accountId": "string",
        "accountNumber": "string",
        "accountName": "string",
        "carrierType": "string",
        "carrierID": "string",
        "taxRegNo": "string",
        "cpfGroupId": "string",
        "language": "string",
        "invoiceDeliveryMethod": "string"
      },
      "designatedCarrier": {
        "preferredCarrier": "string",
        "accountNumber": "string",
        "deliveryMethod": "string"
      },
      "shippingOptions": [
        "string"
      ],
      "items": [
        {
          "itemId": "string",
          "shipFromState": "string",
          "estimatedShippingDateRange": {
            "min": "2023-07-05T21:57:55.357Z",
            "max": "2023-07-05T21:57:55.357Z"
          },
          "siteCode": "string",
          "isDirectShip": true,
          "vendorId": "string",
          "inboundShipMethod": "string",
          "inboundShipmentName": "string"
        }
      ],
      "groupId": "string",
      "shipmentName": "string",
      "contactReferences": [
        {
          "id": "string",
          "resourceReference": {
            "eTag": "string",
            "schema": "string",
            "sourceSystem": "string",
            "location": "string"
          },
          "type": "string"
        }
      ],
      "anESolutionName": "string",
      "agreementId": "string",
      "incoterms": "string",
      "fgaType": "string",
      "consolidationId": "string",
      "consolidationQuantity": 0,
      "consolidationItemQuantity": 0,
      "shippingCarrier": "string",
      "portOfDestination": "string",
      "itemGroupId": "string",
      "isUpgrade": true,
      "installationInstructions": "string",
      "vatpNotes": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      }
    }
  ],
  "references": [
    {
      "referenceCreatedBy": "string",
      "referencedOn": "2023-07-05T21:57:55.357Z",
      "referenceType": "string",
      "target": "string",
      "targetSystem": "string",
      "targetSystemStatus": "string",
      "version": 0
    }
  ],
  "customerSpecificFields": [
    {
      "fieldKey": "string",
      "fieldValue": "string",
      "nameSpace": "string"
    }
  ],
  "validations": [
    {
      "source": "string",
      "message": "string",
      "messageCode": "string",
      "severity": "Info"
    }
  ],
  "promotions": [
    {
      "campaignExclusionId": 0,
      "description": "string"
    }
  ],
  "coupons": [
    {
      "couponCode": "string"
    }
  ],
  "priceAdjustments": [
    {
      "id": "string",
      "isTaxInclusive": true,
      "expirationTime": "2023-07-05T21:57:55.357Z",
      "value": 0,
      "type": "Amount",
      "scope": "Local",
      "targetLevel": "AllItems",
      "targetId": "string",
      "targetParentHierarchy": {
        "id": "string",
        "type": "string",
        "child": "string"
      },
      "isRedemptionAdjustment": true,
      "isQuantityInclusive": true,
      "additionalInfo": [
        {
          "key": "string",
          "value": "string"
        }
      ],
      "isEcofeeInclusivePrice": true
    }
  ],
  "schema": "string",
  "contacts": [
    {
      "id": "string",
      "resourceReference": {
        "eTag": "string",
        "schema": "string",
        "sourceSystem": "string",
        "location": "string"
      },
      "type": "string"
    }
  ],
  "tradeCompliance": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "cfo": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "salesOfferType": "string",
  "commerceContext": {
    "sourceApplicationName": "string",
    "originalSourceApplicationName": "string",
    "accessGroup": "string",
    "companyNumber": "string",
    "country": "string",
    "currency": "string",
    "displayCurrency": "string",
    "customerSet": "string",
    "language": "string",
    "region": "string",
    "segment": "string",
    "businessUnitId": "string",
    "registrationId": "string",
    "pricingRegistrationIdsForTypes": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "destinationSystem": "string",
    "sellingEntity": "string",
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "customerAccountId": 0,
    "classCode": "string",
    "cdcEnabled": true,
    "queueCode": "string",
    "profile": {
      "partyId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "updateProfileInfo": true,
      "personId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "accountId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "orgId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "relationId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "role": "string",
      "pageId": "string",
      "icuCustomerId": "string",
      "accountName": "string"
    },
    "isGlobalPortal": true,
    "useReseller": true,
    "band": 0,
    "isGop": true
  },
  "orderContext": {
    "accessGroup": "string",
    "businessUnitId": "string",
    "classCode": "string",
    "companyNumber": "string",
    "customerSet": "string",
    "originalSourceApplicationName": "string",
    "profile": {
      "partyId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "updateProfileInfo": true,
      "personId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "accountId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "orgId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "relationId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "role": "string",
      "pageId": "string",
      "icuCustomerId": "string",
      "accountName": "string"
    },
    "queueCode": "string",
    "segment": "string",
    "sourceApplicationName": "string"
  },
  "customCheckoutFields": [
    {
      "id": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      }
    }
  ],
  "customerPrivacy": {
    "shareTelephoneWithCarrier": true,
    "hideBillTo": true,
    "deliveryNoteWithPrice": true
  },
  "customerCompliance": {
    "cig": "string",
    "cup": "string",
    "cuu": "string"
  },
  "quotedDate": "2023-07-05T21:57:55.357Z",
  "marketingSource": "string",
  "fraudPrevention": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "isTLACrossBorder": true,
  "isBuildProhibited": true,
  "resellerMarkup": "string",
  "donationCode": "string",
  "smartPrice": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "isCpf": true,
  "orderResiliency": {
    "createDate": "2023-07-05T21:57:55.357Z",
    "resilientOrderId": "string",
    "resiliencyPolicy": {
      "client": {
        "name": "string"
      },
      "retryThreshold": {
        "maxHours": 0
      }
    }
  },
  "largeTransaction": true,
  "orderPath": "string"
}

```

# TSO contract
##### POST /transientSalesOrder
```json
{
  "quoteUrl": "string",
  "cartUrl": "string",
  "salesOrderUrl": "string",
  "quoteNumber": "string",
  "quoteVersion": "string",
  "quoteName": "string",
  "quoteType": "string",
  "solutionId": "string",
  "solutionVersion": "string",
  "solutionRegion": "string",
  "solutionGroupId": "string",
  "solutionRequestRegion": "string",
  "installationInstructions": "string",
  "opportunityId": "string",
  "frameworkDealId": "string",
  "orderCreateDate": "2023-05-12T14:16:17.570Z",
  "fulfillmentUnitsUrl": "string",
  "tradeComplianceUrl": "string",
  "orderType": "string",
  "purchaseOrderNumber": "string",
  "pomId": "string",
  "poDateReceived": "2023-05-12T14:16:17.570Z",
  "salesOfferType": "string",
  "linkToReenteredDpid": "string",
  "createdBy": "string",
  "orderDpid": "string",
  "sfdcCaseNumber": "string",
  "sfdcEmailReferenceNumber": "string",
  "dps": "string",
  "exchangeInfo": {
    "dpsNumber": "string",
    "exchangeReasonCode": "string",
    "exchangeType": "string",
    "mwdType": "string",
    "originalOrderNumber": "string",
    "fsrNumber": "string"
  },
  "insuredReturns": {
    "fusionId": "string",
    "code": "string",
    "comments": "string",
    "pomId": "string"
  },
  "price": {
    "priceUrl": "string",
    "clearPriceUrl": "string",
    "taxInformation": {
      "taxOverRideRate": 0,
      "isTaxOverrideEnabled": true,
      "isStateTaxIncluded": true,
      "category": "string",
      "isExemptFromSalesApp": true,
      "taxExemptCode": "string",
      "taxOverrideFlag": "string",
      "taxOverrideReasonCode": "string",
      "defaultStateForTaxCalculation": "string",
      "isTaxRequired": true,
      "primaryTaxId": "string",
      "exemptTaxType": "string",
      "shipToTaxCategory": "string"
    }
  },
  "reservation": {
    "expirationTime": "string",
    "lookupId": "string",
    "lookupIdType": "string",
    "updateId": "string",
    "updateIdType": "string",
    "updateUid": "string"
  },
  "extendedProperties": {
    "additionalProp1": "string",
    "additionalProp2": "string",
    "additionalProp3": "string"
  },
  "contacts": [
    {
      "id": "string",
      "type": "string",
      "resourceReference": {
        "eTag": "string",
        "schema": "string",
        "sourceSystem": "string",
        "location": "string"
      }
    }
  ],
  "soldTo": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "string",
      "city": "string",
      "country": "string",
      "countryCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "sequenceNumber": "string",
      "cityCode": "string",
      "regionName": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "string",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "string",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxRegNo": "string",
    "bankName": "string",
    "accountNumber": "string",
    "carrierType": "string",
    "carrierID": "string",
    "invoiceType": "string",
    "cpfGroupId": "string",
    "invoiceDeliveryMethod": "string",
    "accountName": "string",
    "language": "string",
    "taxCategory": "string",
    "accountId": "string"
  },
  "billTo": {
    "additionalEmails": [
      {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      }
    ],
    "digitalFulfillmentEmail": "string",
    "warrantyEmailAddress": "string",
    "address": {
      "addressType": "string",
      "city": "string",
      "country": "string",
      "countryCode": "string",
      "id": "string",
      "isValid": true,
      "isAddressVerified": true,
      "line1": "string",
      "line2": "string",
      "line3": "string",
      "line4": "string",
      "line5": "string",
      "other1": "string",
      "other2": "string",
      "other3": "string",
      "other4": "string",
      "other5": "string",
      "postalCode": "string",
      "suburb": "string",
      "region": "string",
      "sequenceNumber": "string",
      "cityCode": "string",
      "regionName": "string"
    },
    "camId": "string",
    "camLocationId": "string",
    "companyName": "string",
    "contactId": "string",
    "contactType": "string",
    "customerNumber": "string",
    "department": "string",
    "emailAddress": "string",
    "emailType": "string",
    "endUserInfo": {
      "customerAccountId": "string",
      "endUserEmail": {
        "email": "string",
        "host": "string",
        "mailToName": "string",
        "type": "string"
      },
      "endUserId": "string",
      "omsCustomerId": "string",
      "partnerRequestId": "string",
      "partnerRequestStatus": "string",
      "partyId": "string",
      "salesChannelId": "string"
    },
    "fax": {
      "countryCode": "string",
      "areaCode": "string",
      "number": "string",
      "phoneType": "string",
      "extension": "string"
    },
    "isValid": true,
    "linkNumber": "string",
    "firstName": "string",
    "middleName": "string",
    "lastName": "string",
    "prefix": "string",
    "suffix": "string",
    "title": "string",
    "organizationInfo": {
      "branchName": "string",
      "companyRegistrationDate": "string",
      "companyRegistrationNo": "string",
      "department": "string",
      "fields": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      },
      "id": "string",
      "name": "string",
      "secondaryName": "string",
      "taxNo": "string",
      "title": "string",
      "type": "string"
    },
    "phoneContacts": [
      {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      }
    ],
    "properties": {
      "additionalProp1": "string",
      "additionalProp2": "string",
      "additionalProp3": "string"
    },
    "secondaryName": {
      "first": "string",
      "last": "string",
      "maGuid": "string",
      "mi": "string",
      "prefix": "string",
      "suffix": "string",
      "title": "string"
    },
    "taxIdPrimary": "string",
    "taxIdSecondary": "string",
    "ucid": "string",
    "optInFlags": 0,
    "marketingPreferences": {
      "additionalProp1": true,
      "additionalProp2": true,
      "additionalProp3": true
    },
    "taxRegNo": "string",
    "bankName": "string",
    "accountNumber": "string",
    "carrierType": "string",
    "carrierID": "string",
    "invoiceType": "string",
    "cpfGroupId": "string",
    "invoiceDeliveryMethod": "string",
    "accountName": "string",
    "language": "string",
    "taxCategory": "string",
    "accountId": "string"
  },
  "items": [
    {
      "id": "string",
      "openBasketItemId": "3fa85f64-5717-4562-b3fc-2c963f66afa6",
      "openBasketCompleteItemUrl": "string",
      "openBasketLiteUrl": "string",
      "configRequestUrl": "string",
      "stockReservationId": "string",
      "itemType": "string",
      "configuredSelectionsUrl": "string",
      "txProductUrl": "string",
      "txMiscellaneousUrl": "string",
      "txRelationship": "string",
      "parentItemId": "string",
      "catalogId": 0,
      "quantity": 0,
      "poLineNumber": "string",
      "isParentAsset": true,
      "targetAssetId": "string",
      "targetAssetType": "string",
      "labelReference": "string",
      "opportunityLineId": "string",
      "goalId": "string",
      "goalLineId": "string",
      "upgrade": {
        "optoutReasonCode": "string"
      },
      "itemExtendedProperties": [
        {
          "key": "string",
          "namespace": "string",
          "value": "string"
        }
      ],
      "metadata": [
        {
          "id": "string",
          "node": "string"
        }
      ],
      "contract": {
        "contractCode": "string",
        "customerClassCode": "string",
        "isContractMandatory": true,
        "lineItemInvoicing": "string",
        "customerAgreementNumber": "string",
        "error": "string",
        "isValid": true,
        "isValidForCustomer": true,
        "isExpired": true,
        "isExpiringBeforeQuote": true,
        "endDate": "string",
        "dellPaysShippingMessage": "string",
        "dellPaysShippingMethod": "string",
        "contractName": "string"
      },
      "skus": [
        {
          "skuNumber": "string",
          "selectedCadence": "string",
          "customerSpecificFields": [
            "string"
          ]
        }
      ],
      "cficomments": [
        {
          "id": "string",
          "comment": "string",
          "code": "string",
          "type": "string",
          "isRequired": "string"
        }
      ],
      "txShopPriceUrl": "string",
      "txValidationUrl": "string",
      "assets": [
        {
          "isParentAsset": true,
          "targetAssetId": "string",
          "targetAssetType": "string"
        }
      ]
    }
  ],
  "salesReps": [
    {
      "id": "string",
      "email": "string",
      "employeeId": "string",
      "salesPersonNumber": "string",
      "firstName": "string",
      "lastName": "string",
      "middleInitial": "string",
      "phone": {
        "countryCode": "string",
        "areaCode": "string",
        "number": "string",
        "phoneType": "string",
        "extension": "string"
      },
      "type": "string",
      "source": "string"
    }
  ],
  "holdReasons": [
    {
      "key": "string",
      "code": "string"
    }
  ],
  "paymentMethods": [
    {
      "id": "string",
      "amount": 0,
      "billPlanId": "string",
      "globalPaymentId": "string",
      "payCode": "string",
      "paymentDescription": "string",
      "term": "string",
      "creditCardType": "string",
      "subscriptionServiceType": [
        "string"
      ],
      "isPrepaid": true,
      "leaseAgreementNumber": "string",
      "isRecurring": true,
      "referenceNumber": "string",
      "paymentReceiptNumber": "string",
      "payerName": "string",
      "payeeAmount": 0,
      "originalOrderNumber": "string",
      "isLease": true,
      "isInterestApplied": true,
      "emiAmountExcludingInstallmentCharges": 0,
      "emiAmountPerInstallment": 0,
      "emiNumberOfInstallments": 0
    }
  ],
  "linkToCancelledOrder": {
    "dpid": 0,
    "omsNumbers": [
      0
    ],
    "quoteNumber": "string",
    "quoteVersion": 0
  },
  "shipments": [
    {
      "id": "string",
      "shippingMethod": "string",
      "arriveByDate": "2023-05-12T14:16:17.571Z",
      "instructions": "string",
      "shippingContact": {
        "shipToTaxCategory": "string",
        "additionalEmails": [
          {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          }
        ],
        "digitalFulfillmentEmail": "string",
        "warrantyEmailAddress": "string",
        "address": {
          "addressType": "string",
          "city": "string",
          "country": "string",
          "countryCode": "string",
          "id": "string",
          "isValid": true,
          "isAddressVerified": true,
          "line1": "string",
          "line2": "string",
          "line3": "string",
          "line4": "string",
          "line5": "string",
          "other1": "string",
          "other2": "string",
          "other3": "string",
          "other4": "string",
          "other5": "string",
          "postalCode": "string",
          "suburb": "string",
          "region": "string",
          "sequenceNumber": "string",
          "cityCode": "string",
          "regionName": "string"
        },
        "camId": "string",
        "camLocationId": "string",
        "companyName": "string",
        "contactId": "string",
        "contactType": "string",
        "customerNumber": "string",
        "department": "string",
        "emailAddress": "string",
        "emailType": "string",
        "endUserInfo": {
          "customerAccountId": "string",
          "endUserEmail": {
            "email": "string",
            "host": "string",
            "mailToName": "string",
            "type": "string"
          },
          "endUserId": "string",
          "omsCustomerId": "string",
          "partnerRequestId": "string",
          "partnerRequestStatus": "string",
          "partyId": "string",
          "salesChannelId": "string"
        },
        "fax": {
          "countryCode": "string",
          "areaCode": "string",
          "number": "string",
          "phoneType": "string",
          "extension": "string"
        },
        "isValid": true,
        "linkNumber": "string",
        "firstName": "string",
        "middleName": "string",
        "lastName": "string",
        "prefix": "string",
        "suffix": "string",
        "title": "string",
        "organizationInfo": {
          "branchName": "string",
          "companyRegistrationDate": "string",
          "companyRegistrationNo": "string",
          "department": "string",
          "fields": {
            "additionalProp1": "string",
            "additionalProp2": "string",
            "additionalProp3": "string"
          },
          "id": "string",
          "name": "string",
          "secondaryName": "string",
          "taxNo": "string",
          "title": "string",
          "type": "string"
        },
        "phoneContacts": [
          {
            "countryCode": "string",
            "areaCode": "string",
            "number": "string",
            "phoneType": "string",
            "extension": "string"
          }
        ],
        "properties": {
          "additionalProp1": "string",
          "additionalProp2": "string",
          "additionalProp3": "string"
        },
        "secondaryName": {
          "first": "string",
          "last": "string",
          "maGuid": "string",
          "mi": "string",
          "prefix": "string",
          "suffix": "string",
          "title": "string"
        },
        "taxIdPrimary": "string",
        "taxIdSecondary": "string",
        "ucid": "string",
        "optInFlags": 0,
        "marketingPreferences": {
          "additionalProp1": true,
          "additionalProp2": true,
          "additionalProp3": true
        },
        "taxRegNo": "string",
        "bankName": "string",
        "accountNumber": "string",
        "carrierType": "string",
        "carrierID": "string",
        "invoiceType": "string",
        "cpfGroupId": "string",
        "invoiceDeliveryMethod": "string",
        "accountName": "string",
        "language": "string",
        "taxCategory": "string",
        "accountId": "string"
      },
      "designatedCarrier": {
        "preferredCarrier": "string",
        "accountNumber": "string",
        "deliveryMethod": "string"
      },
      "shippingOptions": [
        "string"
      ],
      "items": [
        {
          "itemId": "string",
          "shipFromState": "string",
          "siteCode": "string",
          "estimatedShippingDateRange": {
            "min": "2023-05-12T14:16:17.572Z",
            "max": "2023-05-12T14:16:17.572Z"
          },
          "isDirectShip": true,
          "vendorId": "string",
          "inboundShipmentName": "string",
          "inboundShipMethod": "string"
        }
      ],
      "groupId": "string",
      "shipmentName": "string",
      "contactReferences": [
        {
          "id": "string",
          "type": "string",
          "resourceReference": {
            "eTag": "string",
            "schema": "string",
            "sourceSystem": "string",
            "location": "string"
          }
        }
      ],
      "anESolutionName": "string",
      "agreementId": "string",
      "incoterms": "string",
      "fgaType": "string",
      "consolidationId": "string",
      "consolidationQuantity": 0,
      "consolidationItemQuantity": 0,
      "shippingCarrier": "string",
      "portOfDestination": "string",
      "itemGroupId": "string",
      "isUpgrade": true,
      "futuristicDeliveryDate": "2023-05-12T14:16:17.572Z",
      "inboundShipmethod": "string",
      "installationInstructions": "string",
      "vatpNotes": "string",
      "shipFromHub": "string",
      "inboundShipmentName": "string"
    }
  ],
  "customerSpecificFields": [
    {
      "fieldKey": "string",
      "fieldValue": "string",
      "nameSpace": "string"
    }
  ],
  "customCheckoutFields": [
    {
      "id": "string",
      "properties": {
        "additionalProp1": "string",
        "additionalProp2": "string",
        "additionalProp3": "string"
      }
    }
  ],
  "commerceContext": {
    "sourceApplicationName": "string",
    "originalSourceApplicationName": "string",
    "accessGroup": "string",
    "companyNumber": "string",
    "country": "string",
    "currency": "string",
    "customerSet": "string",
    "isGlobalPortal": true,
    "useReseller": true,
    "band": 0,
    "language": "string",
    "region": "string",
    "segment": "string",
    "businessUnitId": "string",
    "destinationSystem": "string",
    "sellingEntity": "string",
    "classCode": "string",
    "cdcEnabled": true,
    "queueCode": "string",
    "customerAccountId": "string",
    "omsCustomerId": "string",
    "channelId": "string",
    "displayCurrency": "string",
    "isGop": true,
    "profile": {
      "partyId": "string",
      "updateProfileInfo": true,
      "personId": "string",
      "accountId": "string",
      "orgId": "string",
      "relationId": "string",
      "role": "string",
      "pageId": "string",
      "icuCustomerId": "string",
      "accountName": "string"
    }
  },
  "coupons": [
    {
      "couponCode": "string"
    }
  ],
  "leadTimeDetails": [
    {
      "openBasketItemId": "string",
      "cceEnabled": true,
      "leadTimeBreakUp": "string",
      "shiftEnabled": true,
      "maxLeadTimeSku": "string",
      "shipFlag": "string",
      "geoCode": "string",
      "manufacturingLeadDays": 0,
      "baseDate": "2023-05-12T14:16:17.572Z",
      "estimatedDeliveryDateRange": {
        "min": "2023-05-12T14:16:17.572Z",
        "max": "2023-05-12T14:16:17.572Z"
      },
      "estimatedShippingDateRange": {
        "min": "2023-05-12T14:16:17.572Z",
        "max": "2023-05-12T14:16:17.572Z"
      },
      "estimatedServiceActivationDateRange": {
        "min": "2023-05-12T14:16:17.572Z",
        "max": "2023-05-12T14:16:17.572Z"
      },
      "estimatedDeliveryDays": {
        "min": 0,
        "max": 0
      },
      "estimatedShipDays": {
        "min": 0,
        "max": 0
      }
    }
  ],
  "smartPrices": [
    {
      "id": "string",
      "openBasketItemId": "string",
      "actualPrice": 0,
      "baseMultiplier": 0,
      "compensationAccelerator": 0,
      "compensationAnchorPrice": 0,
      "compensationDecelerator": 0,
      "compensationRevenue": 0,
      "modifiedCompensationRevenue": 0,
      "serviceRevenue": 0,
      "floorPrice": 0,
      "marginFloorPercentage": 0,
      "recommendedPrice": 0,
      "marginRecommendedSellingPrice": 0,
      "marginCompAnchorSellingPrice": 0,
      "rebateThreshold": 0,
      "rebateType": "string",
      "isRebateEligible": true,
      "leaseIncentive": 0,
      "leaseModifier": 0,
      "standardPartnerDiscount": "string",
      "standardPartnerDiscountValue": "string",
      "standardPartnerMargin": "string",
      "originalRecommendedPrice": 0,
      "originalCompensationAnchorPrice": 0,
      "originalFloorPrice": 0,
      "serviceTypeModifiers": [
        {
          "serviceType": "string",
          "serviceModifier": "string"
        }
      ]
    }
  ],
  "customerPrivacy": {
    "shareTelephoneWithCarrier": true,
    "deliveryNoteWithPrice": true,
    "hideBillTo": true
  },
  "customerCompliance": {
    "cig": "string",
    "cup": "string",
    "cuu": "string"
  },
  "cfo": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "marketingSource": "string",
  "fraudPrevention": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "quotedDate": "2023-05-12T14:16:17.572Z",
  "isTLACrossBorder": true,
  "donationCode": "string",
  "resellerMarkup": "string",
  "resellerException": "string",
  "isCpf": true,
  "smartPrice": {
    "rel": "string",
    "ref": "string",
    "etag": "string",
    "schema": "string"
  },
  "orderPath": "string",
  "itemRelationships": "string"
}

```
